/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.api.projects.BranchInfo;
import com.google.gerrit.extensions.api.projects.BranchInput;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.RefPermission;
import com.google.gerrit.server.project.CreateRefControl;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.RefUtil;
import com.google.gerrit.server.project.RefValidationHelper;
import com.google.gerrit.server.util.MagicBranch;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateBranch
implements RestModifyView<ProjectResource, BranchInput> {
    private static final Logger log = LoggerFactory.getLogger(CreateBranch.class);
    private final Provider<IdentifiedUser> identifiedUser;
    private final PermissionBackend permissionBackend;
    private final GitRepositoryManager repoManager;
    private final GitReferenceUpdated referenceUpdated;
    private final RefValidationHelper refCreationValidator;
    private final CreateRefControl createRefControl;
    private String ref;

    @Inject
    CreateBranch(Provider<IdentifiedUser> identifiedUser, PermissionBackend permissionBackend, GitRepositoryManager repoManager, GitReferenceUpdated referenceUpdated, RefValidationHelper.Factory refHelperFactory, CreateRefControl createRefControl, @Assisted String ref) {
        this.identifiedUser = identifiedUser;
        this.permissionBackend = permissionBackend;
        this.repoManager = repoManager;
        this.referenceUpdated = referenceUpdated;
        this.refCreationValidator = refHelperFactory.create(ReceiveCommand.Type.CREATE);
        this.createRefControl = createRefControl;
        this.ref = ref;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public BranchInfo apply(ProjectResource rsrc, BranchInput input) throws BadRequestException, AuthException, ResourceConflictException, IOException, PermissionBackendException, NoSuchProjectException {
        if (input == null) {
            input = new BranchInput();
        }
        if (input.ref != null && !this.ref.equals(input.ref)) {
            throw new BadRequestException("ref must match URL");
        }
        if (input.revision == null) {
            input.revision = "HEAD";
        }
        while (this.ref.startsWith("/")) {
            this.ref = this.ref.substring(1);
        }
        this.ref = RefNames.fullName(this.ref);
        if (!Repository.isValidRefName(this.ref)) {
            throw new BadRequestException("invalid branch name \"" + this.ref + "\"");
        }
        if (MagicBranch.isMagicBranch(this.ref)) {
            throw new BadRequestException("not allowed to create branches under \"" + MagicBranch.getMagicRefNamePrefix(this.ref) + "\"");
        }
        Branch.NameKey name = new Branch.NameKey(rsrc.getNameKey(), this.ref);
        try (Repository repo = this.repoManager.openRepository(rsrc.getNameKey());){
            ObjectId revid = RefUtil.parseBaseRevision(repo, rsrc.getNameKey(), input.revision);
            RevWalk rw = RefUtil.verifyConnected(repo, revid);
            RevObject object = rw.parseAny(revid);
            if (this.ref.startsWith("refs/heads/")) {
                try {
                    object = rw.parseCommit(object);
                }
                catch (IncorrectObjectTypeException notCommit) {
                    throw new BadRequestException("\"" + input.revision + "\" not a commit");
                }
            }
            this.createRefControl.checkCreateRef(this.identifiedUser, repo, name, object);
            try {
                RefUpdate u = repo.updateRef(this.ref);
                u.setExpectedOldObjectId(ObjectId.zeroId());
                u.setNewObjectId(object.copy());
                u.setRefLogIdent(this.identifiedUser.get().newRefLogIdent());
                u.setRefLogMessage("created via REST from " + input.revision, false);
                this.refCreationValidator.validateRefOperation(rsrc.getName(), this.identifiedUser.get(), u);
                RefUpdate.Result result = u.update(rw);
                switch (result) {
                    case FAST_FORWARD: 
                    case NEW: 
                    case NO_CHANGE: {
                        this.referenceUpdated.fire(name.getParentKey(), u, ReceiveCommand.Type.CREATE, this.identifiedUser.get().getAccount());
                        break;
                    }
                    case LOCK_FAILURE: {
                        if (repo.getRefDatabase().exactRef(this.ref) != null) {
                            throw new ResourceConflictException("branch \"" + this.ref + "\" already exists");
                        }
                        String refPrefix = RefUtil.getRefPrefix(this.ref);
                        while (!"refs/heads/".equals(refPrefix)) {
                            if (repo.getRefDatabase().exactRef(refPrefix) != null) {
                                throw new ResourceConflictException("Cannot create branch \"" + this.ref + "\" since it conflicts with branch \"" + refPrefix + "\".");
                            }
                            refPrefix = RefUtil.getRefPrefix(refPrefix);
                        }
                    }
                    default: {
                        throw new IOException(result.name());
                    }
                }
                BranchInfo info = new BranchInfo();
                info.ref = this.ref;
                info.revision = revid.getName();
                info.canDelete = this.permissionBackend.user(this.identifiedUser).ref(name).testOrFalse(RefPermission.DELETE) ? Boolean.valueOf(true) : null;
                BranchInfo branchInfo = info;
                return branchInfo;
            }
            catch (IOException err) {
                log.error("Cannot create branch \"" + name + "\"", err);
                throw err;
            }
        }
        catch (RefUtil.InvalidRevisionException e) {
            throw new BadRequestException("invalid revision \"" + input.revision + "\"");
        }
    }

    public static interface Factory {
        public CreateBranch create(String var1);
    }
}

