/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.RefPermission;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.project.RefControl;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CreateRefControl {
    private static final Logger log = LoggerFactory.getLogger(CreateRefControl.class);
    private final PermissionBackend permissionBackend;
    private final ProjectCache projectCache;

    @Inject
    CreateRefControl(PermissionBackend permissionBackend, ProjectCache projectCache) {
        this.permissionBackend = permissionBackend;
        this.projectCache = projectCache;
    }

    public void checkCreateRef(Provider<? extends CurrentUser> user, Repository repo, Branch.NameKey branch, RevObject object) throws AuthException, PermissionBackendException, NoSuchProjectException, IOException {
        ProjectState ps = this.projectCache.checkedGet(branch.getParentKey());
        if (ps == null) {
            throw new NoSuchProjectException(branch.getParentKey());
        }
        if (!ps.getProject().getState().permitsWrite()) {
            throw new AuthException("project state does not permit write");
        }
        PermissionBackend.ForRef perm = this.permissionBackend.user(user).ref(branch);
        if (object instanceof RevCommit) {
            perm.check(RefPermission.CREATE);
            this.checkCreateCommit(user, repo, (RevCommit)object, ps, perm);
        } else if (object instanceof RevTag) {
            RevObject target;
            RevTag tag = (RevTag)object;
            try (RevWalk rw = new RevWalk(repo);){
                rw.parseBody(tag);
            }
            catch (IOException e) {
                log.error("RevWalk({}) parsing {}:", branch.getParentKey(), tag.name(), e);
                throw e;
            }
            PersonIdent tagger = tag.getTaggerIdent();
            if (!(tagger == null || user.get().isIdentifiedUser() && user.get().asIdentifiedUser().hasEmailAddress(tagger.getEmailAddress()))) {
                perm.check(RefPermission.FORGE_COMMITTER);
            }
            if ((target = tag.getObject()) instanceof RevCommit) {
                this.checkCreateCommit(user, repo, (RevCommit)target, ps, perm);
            } else {
                this.checkCreateRef(user, repo, branch, target);
            }
            RefControl refControl = ps.controlFor(user.get()).controlForRef(branch);
            if (tag.getFullMessage().contains("-----BEGIN PGP SIGNATURE-----\n")) {
                if (!refControl.canPerform("createSignedTag")) {
                    throw new AuthException("createSignedTag not permitted");
                }
            } else if (!refControl.canPerform("createTag")) {
                throw new AuthException("createTag not permitted");
            }
        }
    }

    private void checkCreateCommit(Provider<? extends CurrentUser> user, Repository repo, RevCommit commit, ProjectState projectState, PermissionBackend.ForRef forRef) throws AuthException, PermissionBackendException {
        try {
            forRef.check(RefPermission.UPDATE);
            return;
        }
        catch (AuthException authException) {
            if (projectState.controlFor(user.get()).isReachableFromHeadsOrTags(repo, commit)) {
                return;
            }
            throw new AuthException(String.format("%s for creating new commit object not permitted", RefPermission.UPDATE.describeForException()));
        }
    }
}

