/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.api.projects.DashboardInfo;
import com.google.gerrit.extensions.common.SetDashboardInput;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.DashboardResource;
import com.google.gerrit.server.project.SetDefaultDashboard;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;

@Singleton
class DeleteDashboard
implements RestModifyView<DashboardResource, SetDashboardInput> {
    private final Provider<SetDefaultDashboard> defaultSetter;

    @Inject
    DeleteDashboard(Provider<SetDefaultDashboard> defaultSetter) {
        this.defaultSetter = defaultSetter;
    }

    public Response<DashboardInfo> apply(DashboardResource resource, SetDashboardInput input) throws RestApiException, IOException, PermissionBackendException {
        if (resource.isProjectDefault()) {
            SetDashboardInput in = new SetDashboardInput();
            in.commitMessage = input != null ? input.commitMessage : null;
            return this.defaultSetter.get().apply(resource, in);
        }
        throw new MethodNotAllowedException();
    }
}

