/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.api.projects.ProjectInput;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.git.MultiProgressMonitor;
import com.google.gerrit.server.git.QueueProvider;
import com.google.gerrit.server.index.IndexExecutor;
import com.google.gerrit.server.index.change.AllChangesIndexer;
import com.google.gerrit.server.index.change.ChangeIndexer;
import com.google.gerrit.server.project.ProjectResource;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.concurrent.Future;
import org.eclipse.jgit.util.io.NullOutputStream;

@RequiresCapability(value="administrateServer")
@Singleton
public class Index
implements RestModifyView<ProjectResource, ProjectInput> {
    private final Provider<AllChangesIndexer> allChangesIndexerProvider;
    private final ChangeIndexer indexer;
    private final ListeningExecutorService executor;

    @Inject
    Index(Provider<AllChangesIndexer> allChangesIndexerProvider, ChangeIndexer indexer, @IndexExecutor(value=QueueProvider.QueueType.BATCH) ListeningExecutorService executor) {
        this.allChangesIndexerProvider = allChangesIndexerProvider;
        this.indexer = indexer;
        this.executor = executor;
    }

    public Response.Accepted apply(ProjectResource resource, ProjectInput input) {
        Project.NameKey project = resource.getNameKey();
        MultiProgressMonitor.Task mpt = new MultiProgressMonitor(ByteStreams.nullOutputStream(), "Reindexing project").beginSubTask("", 0);
        AllChangesIndexer allChangesIndexer = this.allChangesIndexerProvider.get();
        allChangesIndexer.setVerboseOut(NullOutputStream.INSTANCE);
        Future ignored = this.executor.submit(allChangesIndexer.reindexProject(this.indexer, project, mpt, mpt));
        return Response.accepted("Project " + project + " submitted for reindexing");
    }
}

