/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gerrit.common.errors.InvalidNameException;
import dk.brics.automaton.RegExp;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jgit.lib.Repository;

public class RefPattern {
    public static final String USERID_SHARDED = "shardeduserid";
    public static final String USERNAME = "username";
    private static final LoadingCache<String, String> exampleCache = CacheBuilder.newBuilder().maximumSize(4000L).build(new CacheLoader<String, String>(){

        @Override
        public String load(String refPattern) {
            return RefPattern.example(refPattern);
        }
    });

    public static String shortestExample(String refPattern) {
        if (RefPattern.isRE(refPattern)) {
            try {
                return exampleCache.get(refPattern);
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked(e.getCause());
                throw new RuntimeException(e);
            }
        }
        if (refPattern.endsWith("/*")) {
            return refPattern.substring(0, refPattern.length() - 1) + '1';
        }
        return refPattern;
    }

    static String example(String refPattern) {
        return RefPattern.toRegExp(refPattern).toAutomaton().getShortestExample(true).replace('\u0000', '-');
    }

    public static boolean isRE(String refPattern) {
        return refPattern.startsWith("^");
    }

    public static RegExp toRegExp(String refPattern) {
        if (RefPattern.isRE(refPattern)) {
            refPattern = refPattern.substring(1);
        }
        return new RegExp(refPattern, 0);
    }

    public static void validate(String refPattern) throws InvalidNameException {
        String prefix;
        if (refPattern.startsWith("^") ? !Repository.isValidRefName(RefPattern.shortestExample(refPattern)) : !refPattern.equals("refs/*") && (refPattern.endsWith("/*") ? !Repository.isValidRefName(prefix = refPattern.substring(0, refPattern.length() - 2)) : !Repository.isValidRefName(refPattern))) {
            throw new InvalidNameException(refPattern);
        }
        RefPattern.validateRegExp(refPattern);
    }

    public static void validateRegExp(String refPattern) throws InvalidNameException {
        try {
            refPattern = refPattern.replace("${shardeduserid}", "");
            refPattern = refPattern.replace("${username}", "");
            Pattern.compile(refPattern);
        }
        catch (PatternSyntaxException e) {
            throw new InvalidNameException(refPattern + " " + e.getMessage());
        }
    }
}

