/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.ProjectPermission;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Singleton
public class SuggestParentCandidates {
    private final ProjectCache projectCache;
    private final PermissionBackend permissionBackend;
    private final Provider<CurrentUser> user;
    private final AllProjectsName allProjects;

    @Inject
    SuggestParentCandidates(ProjectCache projectCache, PermissionBackend permissionBackend, Provider<CurrentUser> user, AllProjectsName allProjects) {
        this.projectCache = projectCache;
        this.permissionBackend = permissionBackend;
        this.user = user;
        this.allProjects = allProjects;
    }

    public List<Project.NameKey> getNameKeys() throws PermissionBackendException {
        return this.permissionBackend.user(this.user).filter(ProjectPermission.ACCESS, this.parents()).stream().sorted().collect(Collectors.toList());
    }

    private Set<Project.NameKey> parents() {
        HashSet<Project.NameKey> parents = new HashSet<Project.NameKey>();
        for (Project.NameKey p : this.projectCache.all()) {
            Project.NameKey parent;
            ProjectState ps = this.projectCache.get(p);
            if (ps == null || (parent = ps.getProject().getParent()) == null) continue;
            parents.add(parent);
        }
        parents.add(this.allProjects);
        return parents;
    }
}

