/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AcceptsCreate;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.server.project.CreateTag;
import com.google.gerrit.server.project.ListTags;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.TagResource;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;

@Singleton
public class TagsCollection
implements ChildCollection<ProjectResource, TagResource>,
AcceptsCreate<ProjectResource> {
    private final DynamicMap<RestView<TagResource>> views;
    private final Provider<ListTags> list;
    private final CreateTag.Factory createTagFactory;

    @Inject
    public TagsCollection(DynamicMap<RestView<TagResource>> views, Provider<ListTags> list, CreateTag.Factory createTagFactory) {
        this.views = views;
        this.list = list;
        this.createTagFactory = createTagFactory;
    }

    @Override
    public RestView<ProjectResource> list() throws ResourceNotFoundException {
        return this.list.get();
    }

    @Override
    public TagResource parse(ProjectResource resource, IdString id) throws ResourceNotFoundException, IOException {
        return new TagResource(resource.getControl(), this.list.get().get(resource, id));
    }

    @Override
    public DynamicMap<RestView<TagResource>> views() {
        return this.views;
    }

    public CreateTag create(ProjectResource resource, IdString name) {
        return this.createTagFactory.create(name.get());
    }
}

