/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.index.query.AndPredicate;
import com.google.gerrit.index.query.Predicate;
import com.google.gerrit.index.query.QueryBuilder;
import com.google.gerrit.index.query.QueryParseException;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.WatchConfig;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class IsWatchedByPredicate
extends AndPredicate<ChangeData> {
    protected final CurrentUser user;

    protected static String describe(CurrentUser user) {
        if (user.isIdentifiedUser()) {
            return user.getAccountId().toString();
        }
        return user.toString();
    }

    public IsWatchedByPredicate(ChangeQueryBuilder.Arguments args, boolean checkIsVisible) throws QueryParseException {
        super(IsWatchedByPredicate.filters(args, checkIsVisible));
        this.user = args.getUser();
    }

    protected static List<Predicate<ChangeData>> filters(ChangeQueryBuilder.Arguments args, boolean checkIsVisible) throws QueryParseException {
        ArrayList r = new ArrayList();
        ChangeQueryBuilder builder = new ChangeQueryBuilder(args);
        for (WatchConfig.ProjectWatchKey w : IsWatchedByPredicate.getWatches(args)) {
            Predicate<ChangeData> p;
            Predicate f = null;
            if (w.filter() != null) {
                try {
                    f = builder.parse(w.filter());
                    if (QueryBuilder.find(f, IsWatchedByPredicate.class) != null) {
                    }
                }
                catch (QueryParseException e) {}
                continue;
            }
            if ((p = w.project().equals(args.allProjectsName) ? null : builder.project(w.project().get())) != null && f != null) {
                r.add(IsWatchedByPredicate.and(p, f));
                continue;
            }
            if (p != null) {
                r.add(p);
                continue;
            }
            if (f != null) {
                r.add(f);
                continue;
            }
            r.add(builder.status_open());
        }
        if (r.isEmpty()) {
            return IsWatchedByPredicate.none();
        }
        if (checkIsVisible) {
            return ImmutableList.of(IsWatchedByPredicate.or(r), builder.is_visible());
        }
        return ImmutableList.of(IsWatchedByPredicate.or(r));
    }

    protected static Collection<WatchConfig.ProjectWatchKey> getWatches(ChangeQueryBuilder.Arguments args) throws QueryParseException {
        CurrentUser user = args.getUser();
        if (user.isIdentifiedUser()) {
            return args.accountCache.get(args.getUser().getAccountId()).getProjectWatches().keySet();
        }
        return Collections.emptySet();
    }

    protected static List<Predicate<ChangeData>> none() {
        Predicate any = IsWatchedByPredicate.any();
        return ImmutableList.of(IsWatchedByPredicate.not(any));
    }

    @Override
    public int getCost() {
        return 1;
    }

    @Override
    public String toString() {
        String val = IsWatchedByPredicate.describe(this.user);
        if (val.indexOf(32) < 0) {
            return "watchedby:" + val;
        }
        return "watchedby:\"" + val + "\"";
    }
}

