/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeRegexPredicate;
import com.google.gwtorm.server.OrmException;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;

public class RegexRefPredicate
extends ChangeRegexPredicate {
    protected final RunAutomaton pattern;

    public RegexRefPredicate(String re) {
        super(ChangeField.REF, re);
        if (re.startsWith("^")) {
            re = re.substring(1);
        }
        if (re.endsWith("$") && !re.endsWith("\\$")) {
            re = re.substring(0, re.length() - 1);
        }
        this.pattern = new RunAutomaton(new RegExp(re).toAutomaton());
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        Change change = object.change();
        if (change == null) {
            return false;
        }
        return this.pattern.run(change.getDest().get());
    }

    @Override
    public int getCost() {
        return 1;
    }
}

