/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.group;

import com.google.common.base.Preconditions;
import com.google.gerrit.index.IndexConfig;
import com.google.gerrit.index.query.AndSource;
import com.google.gerrit.index.query.IndexPredicate;
import com.google.gerrit.index.query.Predicate;
import com.google.gerrit.index.query.QueryProcessor;
import com.google.gerrit.metrics.MetricMaker;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountLimits;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.group.InternalGroup;
import com.google.gerrit.server.index.group.GroupIndexCollection;
import com.google.gerrit.server.index.group.GroupIndexRewriter;
import com.google.gerrit.server.index.group.GroupSchemaDefinitions;
import com.google.gerrit.server.query.group.GroupIsVisibleToPredicate;
import com.google.inject.Inject;
import com.google.inject.Provider;

public class GroupQueryProcessor
extends QueryProcessor<InternalGroup> {
    private final Provider<CurrentUser> userProvider;
    private final GroupControl.GenericFactory groupControlFactory;

    @Inject
    protected GroupQueryProcessor(Provider<CurrentUser> userProvider, AccountLimits.Factory limitsFactory, MetricMaker metricMaker, IndexConfig indexConfig, GroupIndexCollection indexes, GroupIndexRewriter rewriter, GroupControl.GenericFactory groupControlFactory) {
        super(metricMaker, GroupSchemaDefinitions.INSTANCE, indexConfig, indexes, rewriter, "limit", () -> limitsFactory.create((CurrentUser)userProvider.get()).getQueryLimit());
        this.userProvider = userProvider;
        this.groupControlFactory = groupControlFactory;
    }

    @Override
    protected Predicate<InternalGroup> enforceVisibility(Predicate<InternalGroup> pred) {
        return new AndSource<InternalGroup>(pred, new GroupIsVisibleToPredicate(this.groupControlFactory, this.userProvider.get()), this.start);
    }

    static {
        Preconditions.checkState(!GroupIsVisibleToPredicate.class.isAssignableFrom(IndexPredicate.class), "GroupQueryProcessor assumes visibleto is not used by the index rewriter.");
    }
}

