/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.server.ChangeAccess;
import com.google.gerrit.reviewdb.server.ChangeMessageAccess;
import com.google.gerrit.reviewdb.server.PatchLineCommentAccess;
import com.google.gerrit.reviewdb.server.PatchSetAccess;
import com.google.gerrit.reviewdb.server.PatchSetApprovalAccess;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.reviewdb.server.ReviewDbWrapper;
import com.google.gwtorm.client.Key;
import com.google.gwtorm.server.Access;
import com.google.gwtorm.server.AtomicUpdate;
import com.google.gwtorm.server.ListResultSet;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import java.util.Map;
import java.util.function.Function;

class NoChangesReviewDbWrapper
extends ReviewDbWrapper {
    private final ChangeAccess changes;
    private final PatchSetApprovalAccess patchSetApprovals;
    private final ChangeMessageAccess changeMessages;
    private final PatchSetAccess patchSets;
    private final PatchLineCommentAccess patchComments;
    private boolean inTransaction;

    private static <T> ResultSet<T> empty() {
        return new ListResultSet(ImmutableList.of());
    }

    private static <T, K extends Key<?>> CheckedFuture<T, OrmException> emptyFuture() {
        return Futures.immediateCheckedFuture(null);
    }

    NoChangesReviewDbWrapper(ReviewDb db) {
        super(db);
        this.changes = new Changes(this, this.delegate);
        this.patchSetApprovals = new PatchSetApprovals(this, this.delegate);
        this.changeMessages = new ChangeMessages(this, this.delegate);
        this.patchSets = new PatchSets(this, this.delegate);
        this.patchComments = new PatchLineComments(this, this.delegate);
    }

    @Override
    public boolean changesTablesEnabled() {
        return false;
    }

    @Override
    public ChangeAccess changes() {
        return this.changes;
    }

    @Override
    public PatchSetApprovalAccess patchSetApprovals() {
        return this.patchSetApprovals;
    }

    @Override
    public ChangeMessageAccess changeMessages() {
        return this.changeMessages;
    }

    @Override
    public PatchSetAccess patchSets() {
        return this.patchSets;
    }

    @Override
    public PatchLineCommentAccess patchComments() {
        return this.patchComments;
    }

    @Override
    public void commit() throws OrmException {
        if (!this.inTransaction) {
            this.delegate.commit();
        }
    }

    @Override
    public void rollback() throws OrmException {
        if (this.inTransaction) {
            this.inTransaction = false;
        } else {
            this.delegate.rollback();
        }
    }

    private static class PatchLineComments
    extends AbstractDisabledAccess<PatchLineComment, PatchLineComment.Key>
    implements PatchLineCommentAccess {
        private PatchLineComments(NoChangesReviewDbWrapper wrapper, ReviewDb db) {
            super(wrapper, db.patchComments());
        }

        @Override
        public ResultSet<PatchLineComment> byChange(Change.Id id) {
            return NoChangesReviewDbWrapper.empty();
        }

        @Override
        public ResultSet<PatchLineComment> byPatchSet(PatchSet.Id id) {
            return NoChangesReviewDbWrapper.empty();
        }

        @Override
        public ResultSet<PatchLineComment> publishedByChangeFile(Change.Id id, String file) {
            return NoChangesReviewDbWrapper.empty();
        }

        @Override
        public ResultSet<PatchLineComment> publishedByPatchSet(PatchSet.Id patchset) {
            return NoChangesReviewDbWrapper.empty();
        }

        @Override
        public ResultSet<PatchLineComment> draftByPatchSetAuthor(PatchSet.Id patchset, Account.Id author) {
            return NoChangesReviewDbWrapper.empty();
        }

        @Override
        public ResultSet<PatchLineComment> draftByChangeFileAuthor(Change.Id id, String file, Account.Id author) {
            return NoChangesReviewDbWrapper.empty();
        }

        @Override
        public ResultSet<PatchLineComment> draftByAuthor(Account.Id author) {
            return NoChangesReviewDbWrapper.empty();
        }

        @Override
        public ResultSet<PatchLineComment> all() {
            return NoChangesReviewDbWrapper.empty();
        }
    }

    private static class PatchSetApprovals
    extends AbstractDisabledAccess<PatchSetApproval, PatchSetApproval.Key>
    implements PatchSetApprovalAccess {
        private PatchSetApprovals(NoChangesReviewDbWrapper wrapper, ReviewDb db) {
            super(wrapper, db.patchSetApprovals());
        }

        @Override
        public ResultSet<PatchSetApproval> byChange(Change.Id id) {
            return NoChangesReviewDbWrapper.empty();
        }

        @Override
        public ResultSet<PatchSetApproval> byPatchSet(PatchSet.Id id) {
            return NoChangesReviewDbWrapper.empty();
        }

        @Override
        public ResultSet<PatchSetApproval> byPatchSetUser(PatchSet.Id patchSet, Account.Id account) {
            return NoChangesReviewDbWrapper.empty();
        }

        @Override
        public ResultSet<PatchSetApproval> all() {
            return NoChangesReviewDbWrapper.empty();
        }
    }

    private static class PatchSets
    extends AbstractDisabledAccess<PatchSet, PatchSet.Id>
    implements PatchSetAccess {
        private PatchSets(NoChangesReviewDbWrapper wrapper, ReviewDb db) {
            super(wrapper, db.patchSets());
        }

        @Override
        public ResultSet<PatchSet> byChange(Change.Id id) {
            return NoChangesReviewDbWrapper.empty();
        }

        @Override
        public ResultSet<PatchSet> all() {
            return NoChangesReviewDbWrapper.empty();
        }
    }

    private static class ChangeMessages
    extends AbstractDisabledAccess<ChangeMessage, ChangeMessage.Key>
    implements ChangeMessageAccess {
        private ChangeMessages(NoChangesReviewDbWrapper wrapper, ReviewDb db) {
            super(wrapper, db.changeMessages());
        }

        @Override
        public ResultSet<ChangeMessage> byChange(Change.Id id) throws OrmException {
            return NoChangesReviewDbWrapper.empty();
        }

        @Override
        public ResultSet<ChangeMessage> byPatchSet(PatchSet.Id id) throws OrmException {
            return NoChangesReviewDbWrapper.empty();
        }

        @Override
        public ResultSet<ChangeMessage> all() throws OrmException {
            return NoChangesReviewDbWrapper.empty();
        }
    }

    private static class Changes
    extends AbstractDisabledAccess<Change, Change.Id>
    implements ChangeAccess {
        private Changes(NoChangesReviewDbWrapper wrapper, ReviewDb db) {
            super(wrapper, db.changes());
        }

        @Override
        public ResultSet<Change> all() {
            return NoChangesReviewDbWrapper.empty();
        }
    }

    private static abstract class AbstractDisabledAccess<T, K extends Key<?>>
    implements Access<T, K> {
        private final NoChangesReviewDbWrapper wrapper;
        private final String relationName;
        private final int relationId;
        private final Function<T, K> primaryKey;
        private final Function<Iterable<T>, Map<K, T>> toMap;

        private AbstractDisabledAccess(NoChangesReviewDbWrapper wrapper, Access<T, K> delegate) {
            this.wrapper = wrapper;
            this.relationName = delegate.getRelationName();
            this.relationId = delegate.getRelationID();
            this.primaryKey = delegate::primaryKey;
            this.toMap = delegate::toMap;
        }

        @Override
        public final int getRelationID() {
            return this.relationId;
        }

        @Override
        public final String getRelationName() {
            return this.relationName;
        }

        @Override
        public final K primaryKey(T entity) {
            return (K)((Key)this.primaryKey.apply(entity));
        }

        @Override
        public final Map<K, T> toMap(Iterable<T> iterable) {
            return this.toMap.apply(iterable);
        }

        @Override
        public final ResultSet<T> iterateAllEntities() {
            return NoChangesReviewDbWrapper.empty();
        }

        @Override
        public final CheckedFuture<T, OrmException> getAsync(K key) {
            return NoChangesReviewDbWrapper.emptyFuture();
        }

        @Override
        public final ResultSet<T> get(Iterable<K> keys) {
            return NoChangesReviewDbWrapper.empty();
        }

        @Override
        public final void insert(Iterable<T> instances) {
        }

        @Override
        public final void update(Iterable<T> instances) {
        }

        @Override
        public final void upsert(Iterable<T> instances) {
        }

        @Override
        public final void deleteKeys(Iterable<K> keys) {
        }

        @Override
        public final void delete(Iterable<T> instances) {
        }

        @Override
        public final void beginTransaction(K key) {
            Preconditions.checkState(!this.wrapper.inTransaction, "already in transaction");
            this.wrapper.inTransaction = true;
        }

        @Override
        public final T atomicUpdate(K key, AtomicUpdate<T> update) {
            return null;
        }

        @Override
        public final T get(K id) {
            return null;
        }
    }
}

