/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.account.AccountsUpdate;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_146;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;

public class Schema_147
extends SchemaVersion {
    private final GitRepositoryManager repoManager;
    private final AllUsersName allUsersName;
    private final PersonIdent serverIdent;

    @Inject
    Schema_147(Provider<Schema_146> prior, GitRepositoryManager repoManager, AllUsersName allUsersName, @GerritPersonIdent PersonIdent serverIdent) {
        super(prior);
        this.repoManager = repoManager;
        this.allUsersName = allUsersName;
        this.serverIdent = serverIdent;
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException, SQLException {
        try (Repository repo = this.repoManager.openRepository(this.allUsersName);){
            Set<Account.Id> accountIdsFromReviewDb = this.scanAccounts(db);
            Set accountIdsFromUserBranches = repo.getRefDatabase().getRefs("refs/users/").values().stream().map(r -> Account.Id.fromRef(r.getName())).filter(Objects::nonNull).collect(Collectors.toSet());
            accountIdsFromUserBranches.removeAll(accountIdsFromReviewDb);
            for (Account.Id accountId : accountIdsFromUserBranches) {
                AccountsUpdate.deleteUserBranch(repo, this.allUsersName, GitReferenceUpdated.DISABLED, null, this.serverIdent, accountId);
            }
        }
        catch (IOException e) {
            throw new OrmException("Failed to delete user branches for non-existing accounts.", e);
        }
    }

    private Set<Account.Id> scanAccounts(ReviewDb db) throws SQLException {
        try (Statement stmt = Schema_147.newStatement(db);){
            HashSet<Account.Id> hashSet;
            block13: {
                ResultSet rs = stmt.executeQuery("SELECT account_id FROM accounts");
                try {
                    HashSet<Account.Id> ids = new HashSet<Account.Id>();
                    while (rs.next()) {
                        ids.add(new Account.Id(rs.getInt(1)));
                    }
                    hashSet = ids;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return hashSet;
        }
    }
}

