/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.securestore;

import com.google.common.collect.Lists;
import java.util.List;

public abstract class SecureStore {
    public final String get(String section, String subsection, String name) {
        String[] values = this.getList(section, subsection, name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public final String getForPlugin(String pluginName, String section, String subsection, String name) {
        String[] values = this.getListForPlugin(pluginName, section, subsection, name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public abstract String[] getListForPlugin(String var1, String var2, String var3, String var4);

    public abstract String[] getList(String var1, String var2, String var3);

    public final void set(String section, String subsection, String name, String value) {
        this.setList(section, subsection, name, Lists.newArrayList(value));
    }

    public abstract void setList(String var1, String var2, String var3, List<String> var4);

    public abstract void unset(String var1, String var2, String var3);

    public abstract Iterable<EntryKey> list();

    public abstract boolean isOutdated();

    public abstract void reload();

    public static class EntryKey {
        public final String name;
        public final String section;
        public final String subsection;

        public EntryKey(String section, String subsection, String name) {
            this.name = name;
            this.section = section;
            this.subsection = subsection;
        }
    }
}

