/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.update;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.index.change.ChangeIndexer;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.NoteDbUpdateManager;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.BatchUpdateListener;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gerrit.server.update.Order;
import com.google.gerrit.server.update.RepoContext;
import com.google.gerrit.server.update.RepoOnlyOp;
import com.google.gerrit.server.update.RepoView;
import com.google.gerrit.server.update.UpdateException;
import com.google.gerrit.server.util.RequestId;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;

class NoteDbBatchUpdate
extends BatchUpdate {
    private final ChangeNotes.Factory changeNotesFactory;
    private final ChangeUpdate.Factory changeUpdateFactory;
    private final NoteDbUpdateManager.Factory updateManagerFactory;
    private final ChangeIndexer indexer;
    private final GitReferenceUpdated gitRefUpdated;
    private final ReviewDb db;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static void execute(ImmutableList<NoteDbBatchUpdate> updates, BatchUpdateListener listener, @Nullable RequestId requestId, boolean dryrun) throws UpdateException, RestApiException {
        if (updates.isEmpty()) {
            return;
        }
        NoteDbBatchUpdate.setRequestIds(updates, requestId);
        try {
            indexFutures = new ArrayList<CheckedFuture<?, IOException>>();
            handles = new ArrayList<ChangesHandle>(updates.size());
            order = NoteDbBatchUpdate.getOrder(updates, listener);
            try {
                switch (1.$SwitchMap$com$google$gerrit$server$update$Order[order.ordinal()]) {
                    case 1: {
                        for (NoteDbBatchUpdate u : updates) {
                            u.executeUpdateRepo();
                        }
                        listener.afterUpdateRepos();
                        for (NoteDbBatchUpdate u : updates) {
                            handles.add(u.executeChangeOps(dryrun));
                        }
                        for (ChangesHandle h : handles) {
                            h.execute();
                            indexFutures.addAll(h.startIndexFutures());
                        }
                        listener.afterUpdateRefs();
                        listener.afterUpdateChanges();
                        ** break;
lbl27:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        for (NoteDbBatchUpdate u : updates) {
                            handles.add(u.executeChangeOps(dryrun));
                        }
                        for (NoteDbBatchUpdate u : updates) {
                            u.executeUpdateRepo();
                        }
                        for (ChangesHandle h : handles) {
                            h.execute();
                            indexFutures.addAll(h.startIndexFutures());
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("invalid execution order: " + (Object)order);
                    }
                }
            }
            finally {
                for (ChangesHandle h : handles) {
                    h.close();
                }
            }
            ChangeIndexer.allAsList(indexFutures).get();
            updates.stream().filter((Predicate<NoteDbBatchUpdate>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$execute$0(com.google.gerrit.server.update.NoteDbBatchUpdate ), (Lcom/google/gerrit/server/update/NoteDbBatchUpdate;)Z)()).forEach((Consumer<NoteDbBatchUpdate>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$execute$1(com.google.gerrit.server.update.NoteDbBatchUpdate ), (Lcom/google/gerrit/server/update/NoteDbBatchUpdate;)V)());
            if (!dryrun) {
                for (NoteDbBatchUpdate u : updates) {
                    u.executePostOps();
                }
            }
        }
        catch (Exception e) {
            NoteDbBatchUpdate.wrapAndThrowException(e);
        }
    }

    @Inject
    NoteDbBatchUpdate(GitRepositoryManager repoManager, @GerritPersonIdent PersonIdent serverIdent, ChangeNotes.Factory changeNotesFactory, ChangeUpdate.Factory changeUpdateFactory, NoteDbUpdateManager.Factory updateManagerFactory, ChangeIndexer indexer, GitReferenceUpdated gitRefUpdated, @Assisted ReviewDb db, @Assisted Project.NameKey project, @Assisted CurrentUser user, @Assisted Timestamp when) {
        super(repoManager, serverIdent, project, user, when);
        this.changeNotesFactory = changeNotesFactory;
        this.changeUpdateFactory = changeUpdateFactory;
        this.updateManagerFactory = updateManagerFactory;
        this.indexer = indexer;
        this.gitRefUpdated = gitRefUpdated;
        this.db = db;
    }

    @Override
    public void execute(BatchUpdateListener listener) throws UpdateException, RestApiException {
        NoteDbBatchUpdate.execute(ImmutableList.of(this), listener, this.requestId, false);
    }

    @Override
    protected Context newContext() {
        return new ContextImpl();
    }

    private void executeUpdateRepo() throws UpdateException, RestApiException {
        try {
            this.logDebug("Executing updateRepo on {} ops", this.ops.size());
            RepoContextImpl ctx = new RepoContextImpl();
            for (RepoOnlyOp op : this.ops.values()) {
                op.updateRepo(ctx);
            }
            this.logDebug("Executing updateRepo on {} RepoOnlyOps", this.repoOnlyOps.size());
            for (RepoOnlyOp op : this.repoOnlyOps) {
                op.updateRepo(ctx);
            }
            if (this.onSubmitValidators != null && !this.getRefUpdates().isEmpty()) {
                this.onSubmitValidators.validate(this.project, ctx.getRevWalk().getObjectReader(), this.repoView.getCommands());
            }
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf(e, RestApiException.class);
            throw new UpdateException(e);
        }
    }

    private ChangesHandle executeChangeOps(boolean dryrun) throws Exception {
        this.logDebug("Executing change ops", new Object[0]);
        this.initRepository();
        Repository repo = this.repoView.getRepository();
        Preconditions.checkState(repo.getRefDatabase().performsAtomicTransactions(), "cannot use NoteDb with a repository that does not support atomic batch ref updates: %s", (Object)repo);
        ChangesHandle handle = new ChangesHandle(this.updateManagerFactory.create(this.project).setChangeRepo(repo, this.repoView.getRevWalk(), this.repoView.getInserter(), this.repoView.getCommands()), dryrun);
        if (this.user.isIdentifiedUser()) {
            handle.manager.setRefLogIdent(this.user.asIdentifiedUser().newRefLogIdent(this.when, this.tz));
        }
        handle.manager.setRefLogMessage(this.refLogMessage);
        handle.manager.setPushCertificate(this.pushCert);
        for (Map.Entry e : this.ops.asMap().entrySet()) {
            Change.Id id = (Change.Id)e.getKey();
            ChangeContextImpl ctx = this.newChangeContext(id);
            boolean dirty = false;
            this.logDebug("Applying {} ops for change {}", e.getValue().size(), id);
            for (BatchUpdateOp op : e.getValue()) {
                dirty |= op.updateChange(ctx);
            }
            if (!dirty) {
                this.logDebug("No ops reported dirty, short-circuiting", new Object[0]);
                handle.setResult(id, ChangeResult.SKIPPED);
                continue;
            }
            for (ChangeUpdate u : ctx.updates.values()) {
                handle.manager.add(u);
            }
            if (ctx.deleted) {
                this.logDebug("Change {} was deleted", id);
                handle.manager.deleteChange(id);
                handle.setResult(id, ChangeResult.DELETED);
                continue;
            }
            handle.setResult(id, ChangeResult.UPSERTED);
        }
        return handle;
    }

    private ChangeContextImpl newChangeContext(Change.Id id) throws OrmException {
        boolean isNew;
        this.logDebug("Opening change {} for update", id);
        Change c = (Change)this.newChanges.get(id);
        boolean bl = isNew = c != null;
        if (!isNew) {
            c = ChangeNotes.Factory.newNoteDbOnlyChange(this.project, id);
        } else {
            this.logDebug("Change {} is new", id);
        }
        ChangeNotes notes = this.changeNotesFactory.createForBatchUpdate(c, !isNew);
        return new ChangeContextImpl(notes);
    }

    private void executePostOps() throws Exception {
        ContextImpl ctx = new ContextImpl();
        for (RepoOnlyOp op : this.ops.values()) {
            op.postUpdate(ctx);
        }
        for (RepoOnlyOp op : this.repoOnlyOps) {
            op.postUpdate(ctx);
        }
    }

    private static /* synthetic */ void lambda$execute$1(NoteDbBatchUpdate u) {
        u.gitRefUpdated.fire(u.project, u.batchRefUpdate, (Account)u.getAccount().orElse(null));
    }

    private static /* synthetic */ boolean lambda$execute$0(NoteDbBatchUpdate u) {
        return u.batchRefUpdate != null;
    }

    private class ChangesHandle
    implements AutoCloseable {
        private final NoteDbUpdateManager manager;
        private final boolean dryrun;
        private final Map<Change.Id, ChangeResult> results;

        ChangesHandle(NoteDbUpdateManager manager, boolean dryrun) {
            this.manager = manager;
            this.dryrun = dryrun;
            this.results = new HashMap<Change.Id, ChangeResult>();
        }

        @Override
        public void close() {
            this.manager.close();
        }

        void setResult(Change.Id id, ChangeResult result) {
            ChangeResult old = this.results.putIfAbsent(id, result);
            Preconditions.checkArgument(old == null, "result for change %s already set: %s", (Object)id, (Object)old);
        }

        void execute() throws OrmException, IOException {
            NoteDbBatchUpdate.this.batchRefUpdate = this.manager.execute(this.dryrun);
        }

        List<CheckedFuture<?, IOException>> startIndexFutures() {
            if (this.dryrun) {
                return ImmutableList.of();
            }
            NoteDbBatchUpdate.this.logDebug("Reindexing {} changes", this.results.size());
            ArrayList indexFutures = new ArrayList(this.results.size());
            block5: for (Map.Entry<Change.Id, ChangeResult> e : this.results.entrySet()) {
                Change.Id id = e.getKey();
                switch (e.getValue()) {
                    case UPSERTED: {
                        indexFutures.add(NoteDbBatchUpdate.this.indexer.indexAsync(NoteDbBatchUpdate.this.project, id));
                        continue block5;
                    }
                    case DELETED: {
                        indexFutures.add(NoteDbBatchUpdate.this.indexer.deleteAsync(id));
                        continue block5;
                    }
                    case SKIPPED: {
                        continue block5;
                    }
                }
                throw new IllegalStateException("unexpected result: " + (Object)((Object)e.getValue()));
            }
            return indexFutures;
        }
    }

    private static enum ChangeResult {
        SKIPPED,
        UPSERTED,
        DELETED;

    }

    private class ChangeContextImpl
    extends ContextImpl
    implements ChangeContext {
        private final ChangeNotes notes;
        private final Map<PatchSet.Id, ChangeUpdate> updates;
        private boolean deleted;

        protected ChangeContextImpl(ChangeNotes notes) {
            this.notes = Preconditions.checkNotNull(notes);
            this.updates = new TreeMap<PatchSet.Id, ChangeUpdate>(Comparator.comparing(PatchSet.Id::get));
        }

        @Override
        public ChangeUpdate getUpdate(PatchSet.Id psId) {
            ChangeUpdate u = this.updates.get(psId);
            if (u == null) {
                u = NoteDbBatchUpdate.this.changeUpdateFactory.create(this.notes, NoteDbBatchUpdate.this.user, NoteDbBatchUpdate.this.when);
                if (NoteDbBatchUpdate.this.newChanges.containsKey(this.notes.getChangeId())) {
                    u.setAllowWriteToNewRef(true);
                }
                u.setPatchSetId(psId);
                this.updates.put(psId, u);
            }
            return u;
        }

        @Override
        public ChangeNotes getNotes() {
            return this.notes;
        }

        @Override
        public void dontBumpLastUpdatedOn() {
        }

        @Override
        public void deleteChange() {
            this.deleted = true;
        }
    }

    private class RepoContextImpl
    extends ContextImpl
    implements RepoContext {
        private RepoContextImpl() {
        }

        @Override
        public ObjectInserter getInserter() throws IOException {
            return this.getRepoView().getInserterWrapper();
        }

        @Override
        public void addRefUpdate(ReceiveCommand cmd) throws IOException {
            this.getRepoView().getCommands().add(cmd);
        }
    }

    class ContextImpl
    implements Context {
        ContextImpl() {
        }

        @Override
        public RepoView getRepoView() throws IOException {
            return NoteDbBatchUpdate.this.getRepoView();
        }

        @Override
        public RevWalk getRevWalk() throws IOException {
            return this.getRepoView().getRevWalk();
        }

        @Override
        public Project.NameKey getProject() {
            return NoteDbBatchUpdate.this.project;
        }

        @Override
        public Timestamp getWhen() {
            return NoteDbBatchUpdate.this.when;
        }

        @Override
        public TimeZone getTimeZone() {
            return NoteDbBatchUpdate.this.tz;
        }

        @Override
        public ReviewDb getDb() {
            return NoteDbBatchUpdate.this.db;
        }

        @Override
        public CurrentUser getUser() {
            return NoteDbBatchUpdate.this.user;
        }

        @Override
        public Order getOrder() {
            return NoteDbBatchUpdate.this.order;
        }
    }

    static interface AssistedFactory {
        public NoteDbBatchUpdate create(ReviewDb var1, Project.NameKey var2, CurrentUser var3, Timestamp var4);
    }
}

