/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.api.projects.ConfigInput;
import com.google.gerrit.extensions.client.InheritableBoolean;
import com.google.gerrit.extensions.client.ProjectState;
import com.google.gerrit.extensions.client.SubmitType;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.PutConfig;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.Inject;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@CommandMetaData(name="set-project", description="Change a project's settings")
final class SetProjectCommand
extends SshCommand {
    @Argument(index=0, required=true, metaVar="NAME", usage="name of the project")
    private ProjectControl projectControl;
    @Option(name="--description", aliases={"-d"}, metaVar="DESCRIPTION", usage="description of project")
    private String projectDescription;
    @Option(name="--submit-type", aliases={"-t"}, usage="project submit type\n(default: MERGE_IF_NECESSARY)")
    private SubmitType submitType;
    @Option(name="--contributor-agreements", usage="if contributor agreement is required")
    private InheritableBoolean contributorAgreements;
    @Option(name="--signed-off-by", usage="if signed-off-by is required")
    private InheritableBoolean signedOffBy;
    @Option(name="--content-merge", usage="allow automatic conflict resolving within files")
    private InheritableBoolean contentMerge;
    @Option(name="--change-id", usage="if change-id is required")
    private InheritableBoolean requireChangeID;
    @Option(name="--project-state", aliases={"--ps"}, usage="project's visibility state")
    private ProjectState state;
    @Option(name="--max-object-size-limit", usage="max Git object size for this project")
    private String maxObjectSizeLimit;
    @Inject
    private PutConfig putConfig;

    SetProjectCommand() {
    }

    @Option(name="--use-contributor-agreements", aliases={"--ca"}, usage="if contributor agreement is required")
    void setUseContributorArgreements(boolean on) {
        this.contributorAgreements = InheritableBoolean.TRUE;
    }

    @Option(name="--no-contributor-agreements", aliases={"--nca"}, usage="if contributor agreement is not required")
    void setNoContributorArgreements(boolean on) {
        this.contributorAgreements = InheritableBoolean.FALSE;
    }

    @Option(name="--use-signed-off-by", aliases={"--so"}, usage="if signed-off-by is required")
    void setUseSignedOffBy(boolean on) {
        this.signedOffBy = InheritableBoolean.TRUE;
    }

    @Option(name="--no-signed-off-by", aliases={"--nso"}, usage="if signed-off-by is not required")
    void setNoSignedOffBy(boolean on) {
        this.signedOffBy = InheritableBoolean.FALSE;
    }

    @Option(name="--use-content-merge", usage="allow automatic conflict resolving within files")
    void setUseContentMerge(boolean on) {
        this.contentMerge = InheritableBoolean.TRUE;
    }

    @Option(name="--no-content-merge", usage="don't allow automatic conflict resolving within files")
    void setNoContentMerge(boolean on) {
        this.contentMerge = InheritableBoolean.FALSE;
    }

    @Option(name="--require-change-id", aliases={"--id"}, usage="if change-id is required")
    void setRequireChangeId(boolean on) {
        this.requireChangeID = InheritableBoolean.TRUE;
    }

    @Option(name="--no-change-id", aliases={"--nid"}, usage="if change-id is not required")
    void setNoChangeId(boolean on) {
        this.requireChangeID = InheritableBoolean.FALSE;
    }

    @Override
    protected void run() throws BaseCommand.Failure {
        ConfigInput configInput = new ConfigInput();
        configInput.requireChangeId = this.requireChangeID;
        configInput.submitType = this.submitType;
        configInput.useContentMerge = this.contentMerge;
        configInput.useContributorAgreements = this.contributorAgreements;
        configInput.useSignedOffBy = this.signedOffBy;
        configInput.state = this.state;
        configInput.maxObjectSizeLimit = this.maxObjectSizeLimit;
        configInput.description = Strings.emptyToNull(this.projectDescription) != null ? this.projectDescription : this.projectControl.getProject().getDescription();
        try {
            this.putConfig.apply(new ProjectResource(this.projectControl), configInput);
        }
        catch (RestApiException e) {
            throw this.die(e);
        }
    }
}

