/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtjsonrpc.server;

import com.google.gwtjsonrpc.server.ServletCookieAccess;
import com.google.gwtjsonrpc.server.ValidToken;
import com.google.gwtjsonrpc.server.XsrfException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class SignedToken {
    private static final int INT_SZ = 4;
    private static final String MAC_ALG = "HmacSHA1";
    private final int maxAge;
    private final SecretKeySpec key;
    private final SecureRandom rng;
    private final int tokenLength;

    public static String generateRandomKey() {
        byte[] r = new byte[26];
        new SecureRandom().nextBytes(r);
        return SignedToken.encodeBase64(r);
    }

    public SignedToken(int age) throws XsrfException {
        this(age, SignedToken.generateRandomKey());
    }

    public SignedToken(int age, String keyBase64) throws XsrfException {
        this.maxAge = age > 5 ? age / 5 : age;
        this.key = new SecretKeySpec(SignedToken.decodeBase64(keyBase64), MAC_ALG);
        this.rng = new SecureRandom();
        this.tokenLength = 8 + this.newMac().getMacLength();
    }

    public int getMaxAge() {
        return this.maxAge > 0 ? this.maxAge * 5 : this.maxAge;
    }

    public String getCookieText(String cookieName) {
        boolean ok;
        String val = ServletCookieAccess.get(cookieName);
        try {
            ok = this.checkToken(val, null) != null;
        }
        catch (XsrfException e) {
            ok = false;
        }
        return ok ? ServletCookieAccess.getTokenText(cookieName) : null;
    }

    public String newToken(String text) throws XsrfException {
        int q = this.rng.nextInt();
        byte[] buf = new byte[this.tokenLength];
        SignedToken.encodeInt(buf, 0, q);
        SignedToken.encodeInt(buf, 4, SignedToken.now() ^ q);
        this.computeToken(buf, text);
        return SignedToken.encodeBase64(buf) + '$' + text;
    }

    public ValidToken checkToken(String tokenString, String text) throws XsrfException {
        byte[] in;
        if (tokenString == null || tokenString.length() == 0) {
            return null;
        }
        int s = tokenString.indexOf(36);
        if (s <= 0) {
            return null;
        }
        String recvText = tokenString.substring(s + 1);
        try {
            in = SignedToken.decodeBase64(tokenString.substring(0, s));
        }
        catch (RuntimeException e) {
            return null;
        }
        if (in.length != this.tokenLength) {
            return null;
        }
        int q = SignedToken.decodeInt(in, 0);
        int c = SignedToken.decodeInt(in, 4) ^ q;
        int n = SignedToken.now();
        if (this.maxAge > 0 && Math.abs(c - n) > this.maxAge) {
            return null;
        }
        byte[] gen = new byte[this.tokenLength];
        System.arraycopy(in, 0, gen, 0, 8);
        this.computeToken(gen, text != null ? text : recvText);
        if (!Arrays.equals(gen, in)) {
            return null;
        }
        return new ValidToken(this.maxAge > 0 && c + (this.maxAge >> 1) <= n, recvText);
    }

    private void computeToken(byte[] buf, String text) throws XsrfException {
        Mac m = this.newMac();
        m.update(buf, 0, 8);
        m.update(SignedToken.toBytes(text));
        try {
            m.doFinal(buf, 8);
        }
        catch (ShortBufferException e) {
            throw new XsrfException("Unexpected token overflow", e);
        }
    }

    private Mac newMac() throws XsrfException {
        try {
            Mac m = Mac.getInstance(MAC_ALG);
            m.init(this.key);
            return m;
        }
        catch (NoSuchAlgorithmException e) {
            throw new XsrfException("HmacSHA1 not supported", e);
        }
        catch (InvalidKeyException e) {
            throw new XsrfException("Invalid private key", e);
        }
    }

    private static int now() {
        return (int)(System.currentTimeMillis() / 5000L);
    }

    private static byte[] decodeBase64(String s) {
        return Base64.decodeBase64(SignedToken.toBytes(s));
    }

    private static String encodeBase64(byte[] buf) {
        return SignedToken.toString(Base64.encodeBase64(buf));
    }

    private static void encodeInt(byte[] buf, int o, int v) {
        int _v = v;
        buf[o + 3] = (byte)_v;
        buf[o + 2] = (byte)(_v >>>= 8);
        buf[o + 1] = (byte)(_v >>>= 8);
        buf[o] = (byte)(_v >>>= 8);
    }

    private static int decodeInt(byte[] buf, int o) {
        int r = buf[o] << 8;
        r |= buf[o + 1] & 0xFF;
        r <<= 8;
        return (r |= buf[o + 2] & 0xFF) << 8 | buf[o + 3] & 0xFF;
    }

    private static byte[] toBytes(String s) {
        byte[] r = new byte[s.length()];
        for (int k = r.length - 1; k >= 0; --k) {
            r[k] = (byte)s.charAt(k);
        }
        return r;
    }

    private static String toString(byte[] b) {
        StringBuilder r = new StringBuilder(b.length);
        for (int i = 0; i < b.length; ++i) {
            r.append((char)b[i]);
        }
        return r.toString();
    }
}

