/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.nosql;

import com.google.gwtorm.nosql.IndexFunction;
import com.google.gwtorm.nosql.IndexKeyBuilder;
import com.google.gwtorm.schema.ColumnModel;
import com.google.gwtorm.schema.QueryModel;
import com.google.gwtorm.schema.QueryParser;
import com.google.gwtorm.schema.Util;
import com.google.gwtorm.server.CodeGenSupport;
import com.google.gwtorm.server.GeneratedClassLoader;
import com.google.gwtorm.server.OrmException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.antlr.runtime.tree.Tree;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

class IndexFunctionGen<T>
implements Opcodes {
    private static final Type string = Type.getType(String.class);
    private static final Type object = Type.getType(Object.class);
    private static final Type indexKeyBuilder = Type.getType(IndexKeyBuilder.class);
    private final GeneratedClassLoader classLoader;
    private final QueryModel query;
    private final List<QueryModel.OrderBy> myFields;
    private final Class<T> pojo;
    private final Type pojoType;
    private ClassWriter cw;
    private String superTypeName;
    private String implClassName;
    private String implTypeName;

    IndexFunctionGen(GeneratedClassLoader loader, QueryModel qm, Class<T> t) {
        QueryModel.OrderBy o;
        this.classLoader = loader;
        this.query = qm;
        this.myFields = new ArrayList<QueryModel.OrderBy>();
        for (ColumnModel m : IndexFunctionGen.leaves(this.query.getParameters())) {
            o = new QueryModel.OrderBy(m, false);
            if (this.myFields.contains(o)) continue;
            this.myFields.add(o);
        }
        Iterator<QueryModel.OrderBy> orderby = IndexFunctionGen.orderByLeaves(this.query.getOrderBy()).iterator();
        for (int p = 0; p < this.myFields.size() && orderby.hasNext(); ++p) {
            o = orderby.next();
            if (this.myFields.get(p).equals(o)) continue;
            this.myFields.add(o);
            break;
        }
        while (orderby.hasNext()) {
            this.myFields.add(orderby.next());
        }
        this.pojo = t;
        this.pojoType = Type.getType(this.pojo);
    }

    private static List<ColumnModel> leaves(List<ColumnModel> in) {
        ArrayList<ColumnModel> r = new ArrayList<ColumnModel>(in.size());
        for (ColumnModel m : in) {
            if (m.isNested()) {
                r.addAll(m.getAllLeafColumns());
                continue;
            }
            r.add(m);
        }
        return r;
    }

    private static List<QueryModel.OrderBy> orderByLeaves(List<QueryModel.OrderBy> in) {
        ArrayList<QueryModel.OrderBy> r = new ArrayList<QueryModel.OrderBy>(in.size());
        for (QueryModel.OrderBy m : in) {
            if (m.column.isNested()) {
                for (ColumnModel c : m.column.getAllLeafColumns()) {
                    r.add(new QueryModel.OrderBy(c, m.descending));
                }
                continue;
            }
            r.add(m);
        }
        return r;
    }

    IndexFunction<T> create() throws OrmException {
        this.init();
        this.implementConstructor();
        this.implementGetName();
        this.implementIncludes();
        this.implementEncode();
        this.cw.visitEnd();
        this.classLoader.defineClass(this.implClassName, this.cw.toByteArray());
        try {
            Class<?> c = Class.forName(this.implClassName, true, this.classLoader);
            return IndexFunctionGen.cast(c.newInstance());
        }
        catch (InstantiationException e) {
            throw new OrmException("Cannot create new encoder", e);
        }
        catch (IllegalAccessException e) {
            throw new OrmException("Cannot create new encoder", e);
        }
        catch (ClassNotFoundException e) {
            throw new OrmException("Cannot create new encoder", e);
        }
    }

    private static <T> IndexFunction<T> cast(Object c) {
        return (IndexFunction)c;
    }

    private void init() {
        this.superTypeName = Type.getInternalName(IndexFunction.class);
        this.implClassName = this.pojo.getName() + "_IndexFunction_" + this.query.getName() + "_" + Util.createRandomName();
        this.implTypeName = this.implClassName.replace('.', '/');
        this.cw = new ClassWriter(1);
        this.cw.visit(47, 49, this.implTypeName, null, this.superTypeName, new String[0]);
    }

    private void implementConstructor() {
        String consName = "<init>";
        String consDesc = Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]);
        MethodVisitor mv = this.cw.visitMethod(1, "<init>", consDesc, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, this.superTypeName, "<init>", consDesc);
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementGetName() {
        MethodVisitor mv = this.cw.visitMethod(17, "getName", Type.getMethodDescriptor(Type.getType(String.class), new Type[0]), null, null);
        mv.visitCode();
        mv.visitLdcInsn(this.query.getName());
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementIncludes() throws OrmException {
        MethodVisitor mv = this.cw.visitMethod(1, "includes", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, object), null, null);
        mv.visitCode();
        IncludeCGS cgs = new IncludeCGS(mv);
        cgs.setEntityType(this.pojoType);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, this.pojoType.getInternalName());
        mv.visitVarInsn(58, 1);
        HashSet<ColumnModel> checked = new HashSet<ColumnModel>();
        for (QueryModel.OrderBy orderby : this.myFields) {
            IndexFunctionGen.checkNotNullFields(Collections.singleton(orderby.column), checked, mv, cgs);
        }
        Tree parseTree = this.query.getParseTree();
        if (parseTree != null) {
            this.checkConstants(parseTree, mv, cgs);
        }
        cgs.push(1);
        mv.visitInsn(172);
        mv.visitLabel(cgs.no);
        cgs.push(0);
        mv.visitInsn(172);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private static void checkNotNullFields(Collection<ColumnModel> myFields, Set<ColumnModel> checked, MethodVisitor mv, IncludeCGS cgs) throws OrmException {
        for (ColumnModel f : myFields) {
            if (f.isNested()) {
                IndexFunctionGen.checkNotNullFields(f.getNestedColumns(), checked, mv, cgs);
                continue;
            }
            IndexFunctionGen.checkNotNullScalar(mv, checked, cgs, f);
        }
    }

    private static void checkNotNullScalar(MethodVisitor mv, Set<ColumnModel> checked, IncludeCGS cgs, ColumnModel f) throws OrmException {
        IndexFunctionGen.checkParentNotNull(f.getParent(), checked, mv, cgs);
        cgs.setFieldReference(f);
        switch (Type.getType(f.getPrimitiveType()).getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 9: 
            case 10: {
                if (f.getPrimitiveType() == byte[].class) {
                    cgs.pushFieldValue();
                    mv.visitJumpInsn(198, cgs.no);
                    break;
                }
                if (f.getPrimitiveType() == String.class) {
                    cgs.pushFieldValue();
                    mv.visitJumpInsn(198, cgs.no);
                    break;
                }
                if (f.getPrimitiveType() == Timestamp.class || f.getPrimitiveType() == java.util.Date.class || f.getPrimitiveType() == Date.class) {
                    cgs.pushFieldValue();
                    mv.visitJumpInsn(198, cgs.no);
                    break;
                }
                throw new OrmException("Type " + f.getPrimitiveType() + " not supported for field " + f.getPathToFieldName());
            }
            default: {
                throw new OrmException("Type " + f.getPrimitiveType() + " not supported for field " + f.getPathToFieldName());
            }
        }
    }

    private static void checkParentNotNull(ColumnModel f, Set<ColumnModel> checked, MethodVisitor mv, IncludeCGS cgs) {
        if (f != null && checked.add(f)) {
            IndexFunctionGen.checkParentNotNull(f.getParent(), checked, mv, cgs);
            cgs.setFieldReference(f);
            cgs.pushFieldValue();
            mv.visitJumpInsn(198, cgs.no);
        }
    }

    private void checkConstants(Tree node, MethodVisitor mv, IncludeCGS cgs) throws OrmException {
        switch (node.getType()) {
            case 5: 
            case 18: {
                break;
            }
            case 0: 
            case 4: 
            case 7: {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    this.checkConstants(node.getChild(i), mv, cgs);
                }
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                Tree lhs = node.getChild(0);
                Tree rhs = node.getChild(1);
                if (lhs.getType() != 13) {
                    throw new OrmException("Unsupported query token");
                }
                cgs.setFieldReference(((QueryParser.Column)lhs).getField());
                switch (rhs.getType()) {
                    case 14: {
                        break;
                    }
                    case 21: {
                        cgs.pushFieldValue();
                        mv.visitJumpInsn(153, cgs.no);
                        break;
                    }
                    case 22: {
                        cgs.pushFieldValue();
                        mv.visitJumpInsn(154, cgs.no);
                        break;
                    }
                    case 19: {
                        cgs.pushFieldValue();
                        cgs.push(Integer.parseInt(rhs.getText()));
                        mv.visitJumpInsn(160, cgs.no);
                        break;
                    }
                    case 20: {
                        if (cgs.getFieldReference().getPrimitiveType() == Character.TYPE) {
                            cgs.push(IndexFunctionGen.dequote(rhs.getText()).charAt(0));
                            cgs.pushFieldValue();
                            mv.visitJumpInsn(160, cgs.no);
                            break;
                        }
                        mv.visitLdcInsn(IndexFunctionGen.dequote(rhs.getText()));
                        cgs.pushFieldValue();
                        mv.visitMethodInsn(182, string.getInternalName(), "equals", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, object));
                        mv.visitJumpInsn(153, cgs.no);
                    }
                }
                break;
            }
            default: {
                throw new OrmException("Unsupported query token " + node.toStringTree());
            }
        }
    }

    private static String dequote(String text) {
        return text.substring(1, text.length() - 1);
    }

    private void implementEncode() throws OrmException {
        MethodVisitor mv = this.cw.visitMethod(1, "encode", Type.getMethodDescriptor(Type.VOID_TYPE, indexKeyBuilder, object), null, null);
        mv.visitCode();
        EncodeCGS cgs = new EncodeCGS(mv);
        cgs.setEntityType(this.pojoType);
        mv.visitVarInsn(25, 2);
        mv.visitTypeInsn(192, this.pojoType.getInternalName());
        mv.visitVarInsn(58, 2);
        IndexFunctionGen.encodeFields(this.myFields, mv, cgs);
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    static void encodeFields(Collection<QueryModel.OrderBy> myFields, MethodVisitor mv, EncodeCGS cgs) throws OrmException {
        Iterator<QueryModel.OrderBy> i = myFields.iterator();
        while (i.hasNext()) {
            QueryModel.OrderBy f = i.next();
            IndexFunctionGen.encodeScalar(f, mv, cgs);
            if (!i.hasNext()) continue;
            cgs.delimiter();
        }
    }

    static void encodeField(QueryModel.OrderBy f, MethodVisitor mv, EncodeCGS cgs) throws OrmException {
        if (f.column.isNested()) {
            IndexFunctionGen.encodeFields(IndexFunctionGen.orderByLeaves(Collections.singletonList(f)), mv, cgs);
        } else {
            IndexFunctionGen.encodeScalar(f, mv, cgs);
        }
    }

    private static void encodeScalar(QueryModel.OrderBy f, MethodVisitor mv, EncodeCGS cgs) throws OrmException {
        String method = f.descending ? "desc" : "add";
        ColumnModel c = f.column;
        cgs.setFieldReference(c);
        switch (Type.getType(c.getPrimitiveType()).getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                cgs.pushBuilder();
                cgs.pushFieldValue();
                mv.visitInsn(133);
                mv.visitMethodInsn(182, indexKeyBuilder.getInternalName(), method, Type.getMethodDescriptor(Type.VOID_TYPE, Type.LONG_TYPE));
                break;
            }
            case 7: {
                cgs.pushBuilder();
                cgs.pushFieldValue();
                mv.visitMethodInsn(182, indexKeyBuilder.getInternalName(), method, Type.getMethodDescriptor(Type.VOID_TYPE, Type.LONG_TYPE));
                break;
            }
            case 9: 
            case 10: {
                if (c.getPrimitiveType() == byte[].class) {
                    cgs.pushBuilder();
                    cgs.pushFieldValue();
                    mv.visitMethodInsn(182, indexKeyBuilder.getInternalName(), method, Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(byte[].class)));
                    break;
                }
                if (c.getPrimitiveType() == String.class) {
                    cgs.pushBuilder();
                    cgs.pushFieldValue();
                    mv.visitMethodInsn(182, indexKeyBuilder.getInternalName(), method, Type.getMethodDescriptor(Type.VOID_TYPE, string));
                    break;
                }
                if (c.getPrimitiveType() == Timestamp.class || c.getPrimitiveType() == java.util.Date.class || c.getPrimitiveType() == Date.class) {
                    cgs.pushBuilder();
                    cgs.pushFieldValue();
                    String tsType = Type.getType(c.getPrimitiveType()).getInternalName();
                    mv.visitMethodInsn(182, tsType, "getTime", Type.getMethodDescriptor(Type.LONG_TYPE, new Type[0]));
                    mv.visitMethodInsn(182, indexKeyBuilder.getInternalName(), method, Type.getMethodDescriptor(Type.VOID_TYPE, Type.LONG_TYPE));
                    break;
                }
                throw new OrmException("Type " + c.getPrimitiveType() + " not supported for field " + c.getPathToFieldName());
            }
            default: {
                throw new OrmException("Type " + c.getPrimitiveType() + " not supported for field " + c.getPathToFieldName());
            }
        }
    }

    static class EncodeCGS
    extends CodeGenSupport {
        EncodeCGS(MethodVisitor method) {
            super(method);
        }

        void infinity() {
            this.pushBuilder();
            this.mv.visitMethodInsn(182, indexKeyBuilder.getInternalName(), "infinity", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]));
        }

        void delimiter() {
            this.pushBuilder();
            this.mv.visitMethodInsn(182, indexKeyBuilder.getInternalName(), "delimiter", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]));
        }

        void nul() {
            this.pushBuilder();
            this.mv.visitMethodInsn(182, indexKeyBuilder.getInternalName(), "nul", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]));
        }

        void pushBuilder() {
            this.mv.visitVarInsn(25, 1);
        }

        @Override
        public void pushEntity() {
            this.mv.visitVarInsn(25, 2);
        }
    }

    private static final class IncludeCGS
    extends CodeGenSupport {
        final Label no = new Label();

        private IncludeCGS(MethodVisitor method) {
            super(method);
        }

        @Override
        public void pushEntity() {
            this.mv.visitVarInsn(25, 1);
        }
    }
}

