/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprparse;

import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.ExplodingErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprparse.AutoValue_SoyParsingContext;

public abstract class SoyParsingContext {
    public static SoyParsingContext create(ErrorReporter errorReporter, String namespace, ImmutableMap<String, String> aliasToNamespaceMap) {
        return new AutoValue_SoyParsingContext(errorReporter, namespace, aliasToNamespaceMap);
    }

    public static SoyParsingContext empty(ErrorReporter errorReporter, String namespace) {
        return SoyParsingContext.create(errorReporter, namespace, ImmutableMap.of());
    }

    public static SoyParsingContext exploding() {
        return SoyParsingContext.empty(ExplodingErrorReporter.get(), "fake.namespace");
    }

    public abstract ErrorReporter errorReporter();

    public abstract String namespace();

    abstract ImmutableMap<String, String> aliasToNamespaceMap();

    public String resolveAlias(String sourceName) {
        String alias = this.aliasToNamespaceMap().get(sourceName);
        return alias != null ? alias : sourceName;
    }

    public void report(SourceLocation sourceLocation, SoyErrorKind error, Object ... args) {
        this.errorReporter().report(sourceLocation, error, args);
    }

    public SoyParsingContext withErrorReporter(ErrorReporter errorReporter) {
        return SoyParsingContext.create(errorReporter, this.namespace(), this.aliasToNamespaceMap());
    }
}

