/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.html.passes;

import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.html.AbstractHtmlSoyNodeVisitor;
import com.google.template.soy.html.HtmlDefinitions;
import com.google.template.soy.html.IncrementalHtmlCloseTagNode;
import com.google.template.soy.html.IncrementalHtmlOpenTagNode;
import com.google.template.soy.soytree.SoyNode;

public final class VoidElementVerifyingVisitor
extends AbstractHtmlSoyNodeVisitor<Void> {
    private static final SoyErrorKind INVALID_CLOSE_TAG = SoyErrorKind.of("Closing tag for a void HTML Element was not immediately preceeded by an open tag for the same element. Void HTML Elements are not allowed to have any content. See: http://www.w3.org/TR/html-markup/syntax.html#void-element");
    private final ErrorReporter errorReporter;

    public VoidElementVerifyingVisitor(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    protected void visitIncrementalHtmlCloseTagNode(IncrementalHtmlCloseTagNode node) {
        String tagName = node.getTagName();
        if (!HtmlDefinitions.HTML5_VOID_ELEMENTS.contains(tagName)) {
            return;
        }
        ParentNode parent = node.getParent();
        int previousIndex = parent.getChildIndex(node) - 1;
        if (previousIndex < 0) {
            this.errorReporter.report(node.getSourceLocation(), INVALID_CLOSE_TAG, new Object[0]);
        } else {
            SoyNode.StandaloneNode previousNode = (SoyNode.StandaloneNode)parent.getChild(previousIndex);
            if (previousNode instanceof IncrementalHtmlOpenTagNode && ((IncrementalHtmlOpenTagNode)previousNode).getTagName().equals(tagName)) {
                return;
            }
            this.errorReporter.report(node.getSourceLocation(), INVALID_CLOSE_TAG, new Object[0]);
        }
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }
}

