/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.internal.i18n.SoyBidiUtils;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.ExtractMsgVariablesVisitor;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitor;
import com.google.template.soy.jssrc.internal.OptimizeBidiCodeGenVisitor;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.internal.InsertMsgsVisitor;
import com.google.template.soy.shared.internal.ApiCallScopeUtils;
import com.google.template.soy.shared.internal.GuiceSimpleScope;
import com.google.template.soy.shared.internal.MainEntryPointUtils;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.sharedpasses.opti.SimplifyVisitor;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateRegistry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;

public class JsSrcMain {
    private final GuiceSimpleScope apiCallScope;
    private final SimplifyVisitor simplifyVisitor;
    private final Provider<OptimizeBidiCodeGenVisitor> optimizeBidiCodeGenVisitorProvider;
    private final Provider<GenJsCodeVisitor> genJsCodeVisitorProvider;

    @Inject
    public JsSrcMain(@ApiCallScopeBindingAnnotations.ApiCall GuiceSimpleScope apiCallScope, SimplifyVisitor simplifyVisitor, Provider<OptimizeBidiCodeGenVisitor> optimizeBidiCodeGenVisitorProvider, Provider<GenJsCodeVisitor> genJsCodeVisitorProvider) {
        this.apiCallScope = apiCallScope;
        this.simplifyVisitor = simplifyVisitor;
        this.optimizeBidiCodeGenVisitorProvider = optimizeBidiCodeGenVisitorProvider;
        this.genJsCodeVisitorProvider = genJsCodeVisitorProvider;
    }

    public List<String> genJsSrc(SoyFileSetNode soyTree, TemplateRegistry templateRegistry, SoyJsSrcOptions jsSrcOptions, @Nullable SoyMsgBundle msgBundle, ErrorReporter errorReporter) {
        Preconditions.checkState(!jsSrcOptions.getUseGoogIsRtlForBidiGlobalDir() || jsSrcOptions.shouldProvideRequireSoyNamespaces() || jsSrcOptions.shouldProvideRequireJsFunctions(), "Do not specify useGoogIsRtlForBidiGlobalDir without either shouldProvideRequireSoyNamespaces or shouldProvideRequireJsFunctions.");
        try (GuiceSimpleScope.InScope inScope = this.apiCallScope.enter();){
            inScope.seed(SoyJsSrcOptions.class, jsSrcOptions);
            BidiGlobalDir bidiGlobalDir = SoyBidiUtils.decodeBidiGlobalDirFromJsOptions(jsSrcOptions.getBidiGlobalDir(), jsSrcOptions.getUseGoogIsRtlForBidiGlobalDir());
            ApiCallScopeUtils.seedSharedParams(inScope, msgBundle, bidiGlobalDir);
            if (jsSrcOptions.shouldGenerateGoogMsgDefs()) {
                new ExtractMsgVariablesVisitor().exec(soyTree);
                Preconditions.checkState(bidiGlobalDir != null, "If enabling shouldGenerateGoogMsgDefs, must also set bidi global directionality.");
            } else {
                Preconditions.checkState(bidiGlobalDir == null || bidiGlobalDir.isStaticValue(), "If using bidiGlobalIsRtlCodeSnippet, must also enable shouldGenerateGoogMsgDefs.");
                new InsertMsgsVisitor(msgBundle, errorReporter).exec(soyTree);
            }
            this.optimizeBidiCodeGenVisitorProvider.get().exec(soyTree);
            this.simplifyVisitor.simplify(soyTree, templateRegistry);
            List<String> list = this.genJsCodeVisitorProvider.get().gen(soyTree, templateRegistry, errorReporter);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genJsFiles(SoyFileSetNode soyTree, TemplateRegistry templateRegistry, SoyJsSrcOptions jsSrcOptions, @Nullable String locale, @Nullable SoyMsgBundle msgBundle, String outputPathFormat, String inputPathsPrefix, ErrorReporter errorReporter) throws IOException {
        List<String> jsFileContents = this.genJsSrc(soyTree, templateRegistry, jsSrcOptions, msgBundle, errorReporter);
        ImmutableList<SoyFileNode> srcsToCompile = ImmutableList.copyOf(Iterables.filter(soyTree.getChildren(), SoyFileNode.MATCH_SRC_FILENODE));
        if (srcsToCompile.size() != jsFileContents.size()) {
            throw new AssertionError((Object)String.format("Expected to generate %d code chunk(s), got %d", srcsToCompile.size(), jsFileContents.size()));
        }
        Multimap<String, Integer> outputs = MainEntryPointUtils.mapOutputsToSrcs(locale, outputPathFormat, inputPathsPrefix, srcsToCompile);
        for (String outputFilePath : outputs.keySet()) {
            try (BufferedWriter out = Files.newWriter(new File(outputFilePath), StandardCharsets.UTF_8);){
                boolean isFirst = true;
                for (int inputFileIndex : outputs.get(outputFilePath)) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        out.write("\n;\n");
                    }
                    out.write(jsFileContents.get(inputFileIndex));
                }
            }
        }
    }
}

