/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.restricted;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralCaseSpec;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.util.ULocale;
import java.util.Objects;
import javax.annotation.Nullable;

public final class SoyMsgPluralPart
extends SoyMsgPart {
    private final String pluralVarName;
    private final int offset;
    private final ImmutableList<SoyMsgPart.Case<SoyMsgPluralCaseSpec>> cases;

    public SoyMsgPluralPart(String pluralVarName, int offset, Iterable<SoyMsgPart.Case<SoyMsgPluralCaseSpec>> cases) {
        this.pluralVarName = pluralVarName;
        this.offset = offset;
        this.cases = ImmutableList.copyOf(cases);
    }

    public String getPluralVarName() {
        return this.pluralVarName;
    }

    public int getOffset() {
        return this.offset;
    }

    public ImmutableList<SoyMsgPart.Case<SoyMsgPluralCaseSpec>> getCases() {
        return this.cases;
    }

    public ImmutableList<SoyMsgPart> lookupCase(int pluralValue, @Nullable ULocale locale) {
        ImmutableList<SoyMsgPart> caseParts = null;
        boolean hasNonExplicitCases = false;
        ImmutableList<SoyMsgPart> otherCaseParts = null;
        for (SoyMsgPart.Case case_ : this.getCases()) {
            SoyMsgPluralCaseSpec pluralCaseSpec = (SoyMsgPluralCaseSpec)case_.spec();
            SoyMsgPluralCaseSpec.Type type = pluralCaseSpec.getType();
            if (type == SoyMsgPluralCaseSpec.Type.EXPLICIT) {
                if (pluralCaseSpec.getExplicitValue() != pluralValue) continue;
                caseParts = case_.parts();
                break;
            }
            if (type == SoyMsgPluralCaseSpec.Type.OTHER) {
                otherCaseParts = case_.parts();
                continue;
            }
            hasNonExplicitCases = true;
        }
        if (caseParts == null && hasNonExplicitCases) {
            String pluralKeyword = PluralRules.forLocale(locale).select(pluralValue - this.offset);
            SoyMsgPluralCaseSpec.Type type = new SoyMsgPluralCaseSpec(pluralKeyword).getType();
            for (SoyMsgPart.Case case_ : this.getCases()) {
                if (((SoyMsgPluralCaseSpec)case_.spec()).getType() != type) continue;
                caseParts = case_.parts();
                break;
            }
        }
        if (caseParts == null) {
            caseParts = otherCaseParts;
        }
        return Preconditions.checkNotNull(caseParts);
    }

    public boolean equals(Object other) {
        if (!(other instanceof SoyMsgPluralPart)) {
            return false;
        }
        SoyMsgPluralPart otherPlural = (SoyMsgPluralPart)other;
        return this.offset == otherPlural.offset && this.pluralVarName.equals(otherPlural.pluralVarName) && this.cases.equals(otherPlural.cases);
    }

    public int hashCode() {
        return Objects.hash(SoyMsgPluralPart.class, this.offset, this.pluralVarName, this.cases);
    }
}

