/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parseinfo;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.errorprone.annotations.Immutable;

@Immutable
public class SoyTemplateInfo {
    private final String name;
    private final ImmutableMap<String, ParamRequisiteness> paramMap;
    private final ImmutableSortedSet<String> ijParamSet;

    public SoyTemplateInfo(String name, ImmutableMap<String, ParamRequisiteness> paramMap, ImmutableSortedSet<String> ijParamSet) {
        this.name = name;
        Preconditions.checkArgument(name.lastIndexOf(46) > 0);
        this.paramMap = paramMap;
        this.ijParamSet = ijParamSet;
    }

    public String getName() {
        return this.name;
    }

    public String getPartialName() {
        return this.name.substring(this.name.lastIndexOf(46));
    }

    public ImmutableMap<String, ParamRequisiteness> getParams() {
        return this.paramMap;
    }

    public ImmutableSortedSet<String> getUsedIjParams() {
        return this.ijParamSet;
    }

    public static enum ParamRequisiteness {
        REQUIRED,
        OPTIONAL;

    }
}

