/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.msgs.internal.IcuSyntaxUtils;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.pysrc.internal.GenPyExprsVisitor;
import com.google.template.soy.pysrc.internal.LocalVariableStack;
import com.google.template.soy.pysrc.internal.TranslateToPyExprVisitor;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyExprUtils;
import com.google.template.soy.pysrc.restricted.PyFunctionExprBuilder;
import com.google.template.soy.pysrc.restricted.PyStringExpr;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MsgFuncGenerator {
    private final MsgNode msgNode;
    private final long msgId;
    private final ImmutableList<SoyMsgPart> msgParts;
    private final GenPyExprsVisitor genPyExprsVisitor;
    private final PyFunctionExprBuilder prepareFunc;
    private final PyFunctionExprBuilder renderFunc;
    private final TranslateToPyExprVisitor translateToPyExprVisitor;
    private static final Function<String, String> escaperForPyFormatString = new Function<String, String>(){

        @Override
        public String apply(String str) {
            return str.replaceAll("\\{", "{{").replaceAll("\\}", "}}").replace("'", "\\'");
        }
    };
    private static final Function<String, String> nullEscaper = new Function<String, String>(){

        @Override
        public String apply(String str) {
            return str;
        }
    };

    @AssistedInject
    MsgFuncGenerator(GenPyExprsVisitor.GenPyExprsVisitorFactory genPyExprsVisitorFactory, @Assisted MsgNode msgNode, @Assisted LocalVariableStack localVarExprs, @Assisted ErrorReporter errorReporter) {
        this.msgNode = msgNode;
        this.genPyExprsVisitor = genPyExprsVisitorFactory.create(localVarExprs, errorReporter);
        this.translateToPyExprVisitor = new TranslateToPyExprVisitor(localVarExprs, errorReporter);
        String translator = "translator_impl";
        if (this.msgNode.isPlrselMsg()) {
            if (this.msgNode.isPluralMsg()) {
                this.prepareFunc = new PyFunctionExprBuilder(translator + ".prepare_plural");
                this.renderFunc = new PyFunctionExprBuilder(translator + ".render_plural");
            } else {
                this.prepareFunc = new PyFunctionExprBuilder(translator + ".prepare_icu");
                this.renderFunc = new PyFunctionExprBuilder(translator + ".render_icu");
            }
        } else if (this.msgNode.isRawTextMsg()) {
            this.prepareFunc = new PyFunctionExprBuilder(translator + ".prepare_literal");
            this.renderFunc = new PyFunctionExprBuilder(translator + ".render_literal");
        } else {
            this.prepareFunc = new PyFunctionExprBuilder(translator + ".prepare");
            this.renderFunc = new PyFunctionExprBuilder(translator + ".render");
        }
        MsgUtils.MsgPartsAndIds msgPartsAndIds = MsgUtils.buildMsgPartsAndComputeMsgIdForDualFormat(msgNode);
        Preconditions.checkNotNull(msgPartsAndIds);
        this.msgId = msgPartsAndIds.id;
        this.msgParts = msgPartsAndIds.parts;
        Preconditions.checkState(!this.msgParts.isEmpty());
    }

    PyStringExpr getPyExpr() {
        if (this.msgNode.isPlrselMsg()) {
            return this.msgNode.isPluralMsg() ? this.pyFuncForPluralMsg() : this.pyFuncForSelectMsg();
        }
        return this.msgNode.isRawTextMsg() ? this.pyFuncForRawTextMsg() : this.pyFuncForGeneralMsg();
    }

    private PyStringExpr pyFuncForRawTextMsg() {
        String pyMsgText = MsgFuncGenerator.processMsgPartsHelper(this.msgParts, escaperForPyFormatString);
        this.prepareFunc.addArg(this.msgId).addArg(pyMsgText);
        return this.renderFunc.addArg(this.prepareFunc.asPyExpr()).asPyStringExpr();
    }

    private PyStringExpr pyFuncForGeneralMsg() {
        String pyMsgText = MsgFuncGenerator.processMsgPartsHelper(this.msgParts, escaperForPyFormatString);
        Map<PyExpr, PyExpr> nodePyVarToPyExprMap = this.collectVarNameListAndToPyExprMap();
        this.prepareFunc.addArg(this.msgId).addArg(pyMsgText).addArg(PyExprUtils.convertIterableToPyTupleExpr(nodePyVarToPyExprMap.keySet()));
        return this.renderFunc.addArg(this.prepareFunc.asPyExpr()).addArg(PyExprUtils.convertMapToPyExpr(nodePyVarToPyExprMap)).asPyStringExpr();
    }

    private PyStringExpr pyFuncForPluralMsg() {
        SoyMsgPluralPart pluralPart = (SoyMsgPluralPart)this.msgParts.get(0);
        MsgPluralNode pluralNode = this.msgNode.getRepPluralNode(pluralPart.getPluralVarName());
        Map<PyExpr, PyExpr> nodePyVarToPyExprMap = this.collectVarNameListAndToPyExprMap();
        LinkedHashMap<PyExpr, PyExpr> caseSpecStrToMsgTexts = new LinkedHashMap<PyExpr, PyExpr>();
        for (SoyMsgPart.Case case_ : pluralPart.getCases()) {
            caseSpecStrToMsgTexts.put(new PyStringExpr("'" + case_.spec() + "'"), new PyStringExpr("'" + MsgFuncGenerator.processMsgPartsHelper(case_.parts(), nullEscaper) + "'"));
        }
        this.prepareFunc.addArg(this.msgId).addArg(PyExprUtils.convertMapToPyExpr(caseSpecStrToMsgTexts)).addArg(PyExprUtils.convertIterableToPyTupleExpr(nodePyVarToPyExprMap.keySet()));
        PyExpr pluralPyExpr = (PyExpr)this.translateToPyExprVisitor.exec(pluralNode.getExpr());
        return this.renderFunc.addArg(this.prepareFunc.asPyExpr()).addArg(pluralPyExpr).addArg(PyExprUtils.convertMapToPyExpr(nodePyVarToPyExprMap)).asPyStringExpr();
    }

    private PyStringExpr pyFuncForSelectMsg() {
        Map<PyExpr, PyExpr> nodePyVarToPyExprMap = this.collectVarNameListAndToPyExprMap();
        ImmutableList<SoyMsgPart> msgPartsInIcuSyntax = IcuSyntaxUtils.convertMsgPartsToEmbeddedIcuSyntax(this.msgParts, true);
        String pyMsgText = MsgFuncGenerator.processMsgPartsHelper(msgPartsInIcuSyntax, nullEscaper);
        this.prepareFunc.addArg(this.msgId).addArg(pyMsgText).addArg(PyExprUtils.convertIterableToPyTupleExpr(nodePyVarToPyExprMap.keySet()));
        return this.renderFunc.addArg(this.prepareFunc.asPyExpr()).addArg(PyExprUtils.convertMapToPyExpr(nodePyVarToPyExprMap)).asPyStringExpr();
    }

    private Map<PyExpr, PyExpr> collectVarNameListAndToPyExprMap() {
        LinkedHashMap<PyExpr, PyExpr> nodePyVarToPyExprMap = new LinkedHashMap<PyExpr, PyExpr>();
        for (Map.Entry entry : this.msgNode.getVarNameToRepNodeMap().entrySet()) {
            SoyNode.MsgSubstUnitNode substUnitNode = (SoyNode.MsgSubstUnitNode)entry.getValue();
            PyExpr substPyExpr = null;
            if (substUnitNode instanceof MsgPlaceholderNode) {
                Node phInitialNode = ((AbstractParentSoyNode)((Object)substUnitNode)).getChild(0);
                if (phInitialNode instanceof PrintNode || phInitialNode instanceof CallNode || phInitialNode instanceof RawTextNode) {
                    substPyExpr = PyExprUtils.concatPyExprs(this.genPyExprsVisitor.exec((SoyNode)phInitialNode)).toPyString();
                }
                if (phInitialNode instanceof MsgHtmlTagNode) {
                    substPyExpr = PyExprUtils.concatPyExprs(this.genPyExprsVisitor.execOnChildren((SoyNode.ParentSoyNode)phInitialNode)).toPyString();
                }
            } else if (substUnitNode instanceof MsgPluralNode) {
                substPyExpr = (PyExpr)this.translateToPyExprVisitor.exec(((MsgPluralNode)substUnitNode).getExpr());
            } else if (substUnitNode instanceof MsgSelectNode) {
                substPyExpr = (PyExpr)this.translateToPyExprVisitor.exec(((MsgSelectNode)substUnitNode).getExpr());
            }
            if (substPyExpr == null) continue;
            nodePyVarToPyExprMap.put(new PyStringExpr("'" + (String)entry.getKey() + "'"), substPyExpr);
        }
        return nodePyVarToPyExprMap;
    }

    private static String processMsgPartsHelper(ImmutableList<SoyMsgPart> parts, Function<String, String> escaper) {
        StringBuilder rawMsgTextSb = new StringBuilder();
        for (SoyMsgPart part : parts) {
            if (part instanceof SoyMsgRawTextPart) {
                rawMsgTextSb.append(escaper.apply(((SoyMsgRawTextPart)part).getRawText()));
            }
            if (!(part instanceof SoyMsgPlaceholderPart)) continue;
            String phName = ((SoyMsgPlaceholderPart)part).getPlaceholderName();
            rawMsgTextSb.append("{" + phName + "}");
        }
        return rawMsgTextSb.toString();
    }

    public static interface MsgFuncGeneratorFactory {
        public MsgFuncGenerator create(MsgNode var1, LocalVariableStack var2, ErrorReporter var3);
    }
}

