/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.proto;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.html.types.SafeHtml;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeScript;
import com.google.common.html.types.SafeScriptProto;
import com.google.common.html.types.SafeStyle;
import com.google.common.html.types.SafeStyleProto;
import com.google.common.html.types.SafeStyleSheet;
import com.google.common.html.types.SafeStyleSheetProto;
import com.google.common.html.types.SafeUrl;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.TrustedResourceUrl;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.protobuf.Message;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SanitizedContents;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.types.primitive.SanitizedType;
import java.lang.reflect.Modifier;
import javax.annotation.Nullable;

final class SafeStringTypes {
    static final ImmutableMap<String, SanitizedType> SAFE_PROTO_TO_SANITIZED_TYPE = ImmutableMap.builder().put(SafeHtmlProto.getDescriptor().getFullName(), SanitizedType.HtmlType.getInstance()).put(SafeScriptProto.getDescriptor().getFullName(), (SanitizedType.HtmlType)((Object)SanitizedType.JsType.getInstance())).put(SafeStyleProto.getDescriptor().getFullName(), (SanitizedType.HtmlType)((Object)SanitizedType.CssType.getInstance())).put(SafeStyleSheetProto.getDescriptor().getFullName(), (SanitizedType.HtmlType)((Object)SanitizedType.CssType.getInstance())).put(SafeUrlProto.getDescriptor().getFullName(), (SanitizedType.HtmlType)((Object)SanitizedType.UriType.getInstance())).put(TrustedResourceUrlProto.getDescriptor().getFullName(), (SanitizedType.HtmlType)((Object)SanitizedType.TrustedResourceUriType.getInstance())).build();
    private static final ImmutableMap<Class<?>, Converter> TO_SOY_VALUE = ImmutableMap.builder().put(SafeHtml.class, new Converter(){

        @Override
        public SoyValueProvider apply(Object obj) {
            return SanitizedContents.fromSafeHtml((SafeHtml)obj);
        }
    }).put(SafeHtmlProto.class, new Converter(){

        @Override
        public SoyValueProvider apply(Object obj) {
            return SanitizedContents.fromSafeHtmlProto((SafeHtmlProto)obj);
        }
    }).put(SafeScript.class, new Converter(){

        @Override
        public SoyValueProvider apply(Object obj) {
            return SanitizedContents.fromSafeScript((SafeScript)obj);
        }
    }).put(SafeScriptProto.class, new Converter(){

        @Override
        public SoyValueProvider apply(Object obj) {
            return SanitizedContents.fromSafeScriptProto((SafeScriptProto)obj);
        }
    }).put(SafeStyle.class, new Converter(){

        @Override
        public SoyValueProvider apply(Object obj) {
            return SanitizedContents.fromSafeStyle((SafeStyle)obj);
        }
    }).put(SafeStyleProto.class, new Converter(){

        @Override
        public SoyValueProvider apply(Object obj) {
            return SanitizedContents.fromSafeStyleProto((SafeStyleProto)obj);
        }
    }).put(SafeStyleSheet.class, new Converter(){

        @Override
        public SoyValueProvider apply(Object obj) {
            return SanitizedContents.fromSafeStyleSheet((SafeStyleSheet)obj);
        }
    }).put(SafeStyleSheetProto.class, new Converter(){

        @Override
        public SoyValueProvider apply(Object obj) {
            return SanitizedContents.fromSafeStyleSheetProto((SafeStyleSheetProto)obj);
        }
    }).put(SafeUrl.class, new Converter(){

        @Override
        public SoyValueProvider apply(Object obj) {
            return SanitizedContents.fromSafeUrl((SafeUrl)obj);
        }
    }).put(SafeUrlProto.class, new Converter(){

        @Override
        public SoyValueProvider apply(Object obj) {
            return SanitizedContents.fromSafeUrlProto((SafeUrlProto)obj);
        }
    }).put(TrustedResourceUrl.class, new Converter(){

        @Override
        public SoyValueProvider apply(Object obj) {
            return SanitizedContents.fromTrustedResourceUrl((TrustedResourceUrl)obj);
        }
    }).put(TrustedResourceUrlProto.class, new Converter(){

        @Override
        public SoyValueProvider apply(Object obj) {
            return SanitizedContents.fromTrustedResourceUrlProto((TrustedResourceUrlProto)obj);
        }
    }).build();

    private SafeStringTypes() {
    }

    @Nullable
    static SoyValueProvider convertToSoyValue(Object obj) {
        if (obj == null) {
            return null;
        }
        Converter converter = TO_SOY_VALUE.get(obj.getClass());
        if (converter != null) {
            return (SoyValueProvider)converter.apply(obj);
        }
        return null;
    }

    static Message convertToProto(SanitizedContent value, String protoName) {
        switch (value.getContentKind()) {
            case HTML: {
                return value.toSafeHtmlProto();
            }
            case ATTRIBUTES: {
                throw new IllegalStateException("ContentKind.ATTRIBUTES is incompatible with " + protoName);
            }
            case JS: {
                return value.toSafeScriptProto();
            }
            case CSS: {
                if (SafeStyleProto.getDescriptor().getFullName().equals(protoName)) {
                    return value.toSafeStyleProto();
                }
                if (SafeStyleSheetProto.getDescriptor().getFullName().equals(protoName)) {
                    return value.toSafeStyleSheetProto();
                }
                throw new AssertionError((Object)("unexpected proto name: " + protoName));
            }
            case URI: {
                return value.toSafeUrlProto();
            }
            case TRUSTED_RESOURCE_URI: {
                return value.toTrustedResourceUrlProto();
            }
        }
        throw new AssertionError((Object)("unexpected ContentKind: " + (Object)((Object)value.getContentKind())));
    }

    static {
        for (Class cl : TO_SOY_VALUE.keySet()) {
            if (!Modifier.isFinal(cl.getModifiers())) {
                throw new AssertionError((Object)(cl + " is not final so there might be subclasses that aren't keyed in this map"));
            }
        }
    }

    private static interface Converter
    extends Function<Object, SoyValueProvider> {
    }
}

