/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.keyboard;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.server.auth.AbstractUserAuth;
import org.apache.sshd.server.auth.keyboard.InteractiveChallenge;
import org.apache.sshd.server.auth.keyboard.KeyboardInteractiveAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class UserAuthKeyboardInteractive
extends AbstractUserAuth {
    public static final String NAME = "keyboard-interactive";

    public UserAuthKeyboardInteractive() {
        super(NAME);
    }

    @Override
    protected Boolean doAuth(Buffer buffer, boolean init) throws Exception {
        boolean authed;
        ServerSession session = this.getServerSession();
        String username = this.getUsername();
        KeyboardInteractiveAuthenticator auth = session.getKeyboardInteractiveAuthenticator();
        if (init) {
            InteractiveChallenge challenge;
            String lang = buffer.getString();
            String subMethods = buffer.getString();
            if (auth == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("doAuth({}@{})[methods={}, lang={}] - no interactive authenticator to generate challenge", username, session, subMethods, lang);
                }
                return false;
            }
            try {
                challenge = auth.generateChallenge(session, username, lang, subMethods);
            }
            catch (Error e) {
                this.log.warn("doAuth({}@{}) failed ({}) to generate authenticator challenge: {}", username, session, e.getClass().getSimpleName(), e.getMessage());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("doAuth(" + username + "@" + session + ") authenticator challenge failure details", e);
                }
                throw new RuntimeSshException(e);
            }
            if (challenge == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("doAuth({}@{})[methods={}, lang={}] - no interactive challenge generated", username, session, subMethods, lang);
                }
                return false;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("doAuth({}@{})[methods={}, lang={}] challenge name={}, instruction={}, lang={}, num. prompts={}", username, session, subMethods, lang, challenge.getInteractionName(), challenge.getInteractionInstruction(), challenge.getLanguageTag(), GenericUtils.size(challenge.getPrompts()));
            }
            buffer = session.createBuffer((byte)60);
            challenge.append(buffer);
            session.writePacket(buffer);
            return null;
        }
        int cmd = buffer.getUByte();
        if (cmd != 61) {
            throw new SshException("Received unexpected message: " + SshConstants.getCommandMessageName(cmd));
        }
        int num = buffer.getInt();
        ArrayList<String> responses = num <= 0 ? Collections.emptyList() : new ArrayList<String>(num);
        for (int index = 0; index < num; ++index) {
            String value = buffer.getString();
            if (this.log.isTraceEnabled()) {
                this.log.trace("doAuth({}@{}) response #{}: {}", username, session, index + 1, value);
            }
            responses.add(value);
        }
        if (auth == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("doAuth({}@{}) no interactive authenticator to validate {} responses", username, session, num);
            }
            return false;
        }
        try {
            authed = auth.authenticate(session, username, responses);
        }
        catch (Error e) {
            this.log.warn("doAuth({}@{}) failed ({}) to consult authenticator: {}", username, session, e.getClass().getSimpleName(), e.getMessage());
            if (this.log.isDebugEnabled()) {
                this.log.debug("doAuth(" + username + "@" + session + ") authenticator consultation failure details", e);
            }
            throw new RuntimeSshException(e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("doAuth({}@{}) authenticate {} responses result: {}", username, session, num, authed);
        }
        return authed;
    }
}

