/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.parserunners;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.parboiled.MatchHandler;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.errors.BasicParseError;
import org.parboiled.matchers.TestNotMatcher;
import org.parboiled.parserunners.AbstractParseRunner;
import org.parboiled.support.ParsingResult;

public class ErrorLocatingParseRunner<V>
extends AbstractParseRunner<V>
implements MatchHandler {
    private final MatchHandler inner;
    private int errorIndex;

    public ErrorLocatingParseRunner(Rule rule) {
        this(rule, null);
    }

    public ErrorLocatingParseRunner(Rule rule, @Nullable MatchHandler inner) {
        super(rule);
        this.inner = inner;
    }

    @Override
    public ParsingResult<V> run(InputBuffer inputBuffer) {
        Preconditions.checkNotNull(inputBuffer, "inputBuffer");
        this.resetValueStack();
        this.errorIndex = 0;
        MatcherContext rootContext = this.createRootContext(inputBuffer, this, false);
        boolean matched = this.match(rootContext);
        if (!matched) {
            this.parseErrors.add(new BasicParseError(inputBuffer, this.errorIndex, null));
        }
        return this.createParsingResult(matched, rootContext);
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        boolean condition;
        boolean bl = condition = this.inner == null ? context.getMatcher().match(context) : this.inner.match(context);
        if (!condition) {
            return false;
        }
        if (this.errorIndex < context.getCurrentIndex() && ErrorLocatingParseRunner.notTestNot(context)) {
            this.errorIndex = context.getCurrentIndex();
        }
        return true;
    }

    private static boolean notTestNot(MatcherContext<?> context) {
        if (context.getMatcher() instanceof TestNotMatcher) {
            return false;
        }
        return context.getParent() == null || ErrorLocatingParseRunner.notTestNot(context.getParent());
    }
}

