/*
 * Decompiled with CFR 0.152.
 */
package com.github.parboiled1.grappa.matchers.trie;

import com.github.parboiled1.grappa.matchers.trie.Trie;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;
import org.parboiled.MatcherContext;
import org.parboiled.matchers.AbstractMatcher;
import org.parboiled.matchervisitors.MatcherVisitor;

@Immutable
@Beta
public final class TrieMatcher
extends AbstractMatcher {
    private final Trie trie;

    public TrieMatcher(Trie trie) {
        super("Trie (" + Preconditions.checkNotNull(trie).getNrWords() + " strings)");
        this.trie = trie;
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        int maxLength = this.trie.getMaxLength();
        int index = context.getCurrentIndex();
        String input = context.getInputBuffer().extract(index, index + maxLength);
        int ret = this.trie.search(input);
        if (ret == -1) {
            return false;
        }
        context.advanceIndex(ret);
        return true;
    }

    public boolean trieHasStart(char c) {
        return this.trie.trieHasStart(c);
    }

    @Override
    public <R> R accept(MatcherVisitor<R> visitor) {
        return visitor.visit(this);
    }
}

