/*
 * Decompiled with CFR 0.152.
 */
package com.github.parboiled1.grappa.transform.hash;

import com.github.parboiled1.grappa.transform.hash.FieldNodeFunnel;
import com.github.parboiled1.grappa.transform.hash.LabelListFunnel;
import com.github.parboiled1.grappa.transform.hash.LdcInsnFunnel;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.FieldNode;
import org.parboiled.transform.InstructionGroup;

@NotThreadSafe
public final class InstructionGroupHasher
extends MethodVisitor {
    private static final BaseEncoding BASE_ENCODING = BaseEncoding.base32Hex();
    private static final HashFunction SHA1 = Hashing.sha1();
    private final String className;
    private final InstructionGroup group;
    private final Hasher hasher;
    private final LabelListFunnel labelFunnel = new LabelListFunnel();

    public static void hash(@Nonnull InstructionGroup group, @Nonnull String className) {
        InstructionGroupHasher groupHasher = new InstructionGroupHasher(group, className);
        String name = groupHasher.hashAndGetName();
        group.setName(name);
    }

    private InstructionGroupHasher(@Nonnull InstructionGroup group, @Nonnull String className) {
        super(327680);
        this.group = Preconditions.checkNotNull(group);
        this.className = Preconditions.checkNotNull(className);
        this.hasher = SHA1.newHasher();
    }

    private String hashAndGetName() {
        this.group.getInstructions().accept(this);
        for (FieldNode node : this.group.getFields()) {
            this.hasher.putObject(node, FieldNodeFunnel.INSTANCE);
        }
        byte[] hash = new byte[10];
        this.hasher.hash().writeBytesTo(hash, 0, 10);
        String prefix = this.group.getRoot().isActionRoot() ? "Action$" : "VarInit$";
        return prefix + BASE_ENCODING.encode(hash);
    }

    @Override
    public void visitInsn(int opcode) {
        this.hasher.putInt(opcode);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.hasher.putInt(opcode).putInt(operand);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.hasher.putInt(opcode).putInt(var);
        if (opcode == 25 && var == 0) {
            this.hasher.putUnencodedChars(this.className);
        }
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        this.hasher.putInt(opcode).putUnencodedChars(type);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.hasher.putInt(opcode).putUnencodedChars(owner).putUnencodedChars(name).putUnencodedChars(desc);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this.hasher.putInt(opcode).putUnencodedChars(owner).putUnencodedChars(name).putUnencodedChars(desc);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.hasher.putInt(opcode).putObject(label, this.labelFunnel);
    }

    @Override
    public void visitLabel(Label label) {
        this.hasher.putObject(label, this.labelFunnel);
    }

    @Override
    public void visitLdcInsn(Object cst) {
        this.hasher.putObject(cst, LdcInsnFunnel.INSTANCE);
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.hasher.putInt(var).putInt(increment);
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        this.hasher.putInt(min).putInt(max).putObject(dflt, this.labelFunnel);
        for (Label label : labels) {
            this.hasher.putObject(label, this.labelFunnel);
        }
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.hasher.putObject(dflt, this.labelFunnel);
        for (int i = 0; i < keys.length; ++i) {
            this.hasher.putInt(keys[i]).putObject(labels[i], this.labelFunnel);
        }
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.hasher.putUnencodedChars(desc).putInt(dims);
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.hasher.putObject(start, this.labelFunnel).putObject(end, this.labelFunnel).putObject(handler, this.labelFunnel).putUnencodedChars(type);
    }
}

