/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.common.Nullable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public enum LabelFunction {
    MAX_WITH_BLOCK("MaxWithBlock", true),
    ANY_WITH_BLOCK("AnyWithBlock", true),
    MAX_NO_BLOCK("MaxNoBlock", false),
    NO_BLOCK("NoBlock", false),
    NO_OP("NoOp", false),
    PATCH_SET_LOCK("PatchSetLock", false);

    public static final Map<String, LabelFunction> ALL;
    private final String name;
    private final boolean isBlock;

    public static Optional<LabelFunction> parse(@Nullable String str) {
        return Optional.ofNullable(ALL.get(str));
    }

    private LabelFunction(String name, boolean isBlock) {
        this.name = name;
        this.isBlock = isBlock;
    }

    public String getFunctionName() {
        return this.name;
    }

    public boolean isBlock() {
        return this.isBlock;
    }

    static {
        LinkedHashMap<String, LabelFunction> all = new LinkedHashMap<String, LabelFunction>();
        for (LabelFunction f : LabelFunction.values()) {
            all.put(f.getFunctionName(), f);
        }
        ALL = Collections.unmodifiableMap(all);
    }
}

