/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.reviewdb.client.LabelId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LabelTypes {
    protected List<LabelType> labelTypes;
    private volatile transient Map<String, LabelType> byLabel;
    private volatile transient Map<String, Integer> positions;

    protected LabelTypes() {
    }

    public LabelTypes(List<? extends LabelType> approvals) {
        this.labelTypes = Collections.unmodifiableList(new ArrayList<LabelType>(approvals));
    }

    public List<LabelType> getLabelTypes() {
        return this.labelTypes;
    }

    public LabelType byLabel(LabelId labelId) {
        return this.byLabel().get(labelId.get().toLowerCase());
    }

    public LabelType byLabel(String labelName) {
        return this.byLabel().get(labelName.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, LabelType> byLabel() {
        if (this.byLabel == null) {
            LabelTypes labelTypes = this;
            synchronized (labelTypes) {
                if (this.byLabel == null) {
                    HashMap<String, LabelType> l = new HashMap<String, LabelType>();
                    if (this.labelTypes != null) {
                        for (LabelType t : this.labelTypes) {
                            l.put(t.getName().toLowerCase(), t);
                        }
                    }
                    this.byLabel = l;
                }
            }
        }
        return this.byLabel;
    }

    public String toString() {
        return this.labelTypes.toString();
    }

    public Comparator<String> nameComparator() {
        final Map<String, Integer> positions = this.positions();
        return new Comparator<String>(){

            @Override
            public int compare(String left, String right) {
                int rp;
                int lp = this.position(left);
                int cmp = lp - (rp = this.position(right));
                if (cmp == 0) {
                    cmp = left.compareTo(right);
                }
                return cmp;
            }

            private int position(String name) {
                Integer p = (Integer)positions.get(name);
                return p != null ? p.intValue() : positions.size();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Integer> positions() {
        if (this.positions == null) {
            LabelTypes labelTypes = this;
            synchronized (labelTypes) {
                if (this.positions == null) {
                    HashMap<String, Integer> p = new HashMap<String, Integer>();
                    if (this.labelTypes != null) {
                        int i = 0;
                        for (LabelType t : this.labelTypes) {
                            p.put(t.getName(), i++);
                        }
                    }
                    this.positions = p;
                }
            }
        }
        return this.positions;
    }
}

