/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.auth.oauth;

import java.io.Serializable;

public class OAuthToken
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String token;
    private final String secret;
    private final String raw;
    private final long expiresAt;
    private final String providerId;

    public OAuthToken(String token, String secret, String raw) {
        this(token, secret, raw, Long.MAX_VALUE, null);
    }

    public OAuthToken(String token, String secret, String raw, long expiresAt, String providerId) {
        this.token = token;
        this.secret = secret;
        this.raw = raw;
        this.expiresAt = expiresAt;
        this.providerId = providerId;
    }

    public String getToken() {
        return this.token;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getRaw() {
        return this.raw;
    }

    public long getExpiresAt() {
        return this.expiresAt;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.expiresAt;
    }

    public String getProviderId() {
        return this.providerId;
    }
}

