/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.index.query;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gerrit.index.Index;
import com.google.gerrit.index.IndexCollection;
import com.google.gerrit.index.IndexConfig;
import com.google.gerrit.index.Schema;
import com.google.gerrit.index.query.Predicate;
import com.google.gerrit.index.query.QueryParseException;
import com.google.gerrit.index.query.QueryProcessor;
import com.google.gerrit.index.query.QueryResult;
import com.google.gwtorm.server.OrmException;
import java.util.List;
import java.util.Set;

public class InternalQuery<T> {
    private final QueryProcessor<T> queryProcessor;
    private final IndexCollection<?, T, ? extends Index<?, T>> indexes;
    protected final IndexConfig indexConfig;

    protected InternalQuery(QueryProcessor<T> queryProcessor, IndexCollection<?, T, ? extends Index<?, T>> indexes, IndexConfig indexConfig) {
        this.queryProcessor = queryProcessor.enforceVisibility(false);
        this.indexes = indexes;
        this.indexConfig = indexConfig;
    }

    public InternalQuery<T> setLimit(int n) {
        this.queryProcessor.setUserProvidedLimit(n);
        return this;
    }

    public InternalQuery<T> enforceVisibility(boolean enforce) {
        this.queryProcessor.enforceVisibility(enforce);
        return this;
    }

    public InternalQuery<T> setRequestedFields(Set<String> fields) {
        this.queryProcessor.setRequestedFields(fields);
        return this;
    }

    public InternalQuery<T> noFields() {
        this.queryProcessor.setRequestedFields(ImmutableSet.of());
        return this;
    }

    public List<T> query(Predicate<T> p) throws OrmException {
        try {
            return this.queryProcessor.query(p).entities();
        }
        catch (QueryParseException e) {
            throw new OrmException(e);
        }
    }

    public List<List<T>> query(List<Predicate<T>> queries) throws OrmException {
        try {
            return Lists.transform(this.queryProcessor.query(queries), QueryResult::entities);
        }
        catch (QueryParseException e) {
            throw new OrmException(e);
        }
    }

    protected Schema<T> schema() {
        Index<?, T> index = this.indexes != null ? this.indexes.getSearchIndex() : null;
        return index != null ? index.getSchema() : null;
    }
}

