/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.client;

import com.google.gerrit.extensions.client.ChangeStatus;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetInfo;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.IntKey;
import com.google.gwtorm.client.RowVersion;
import com.google.gwtorm.client.StringKey;
import java.sql.Timestamp;
import java.util.Arrays;

public final class Change {
    private static final char MIN_OPEN = 'a';
    public static final char STATUS_NEW = 'n';
    private static final char MAX_OPEN = 'z';
    public static final char STATUS_MERGED = 'M';
    public static final int INITIAL_PATCH_SET_ID = 1;
    public static final String CHANGE_ID_PATTERN = "^[iI][0-9a-f]{4,}.*$";
    @Column(id=1)
    protected Id changeId;
    @Column(id=2)
    protected Key changeKey;
    @Column(id=3)
    @RowVersion
    protected int rowVersion;
    @Column(id=4)
    protected Timestamp createdOn;
    @Column(id=5)
    protected Timestamp lastUpdatedOn;
    @Column(id=7, name="owner_account_id")
    protected Account.Id owner;
    @Column(id=8)
    protected Branch.NameKey dest;
    @Column(id=10)
    protected char status;
    @Column(id=12)
    protected int currentPatchSetId;
    @Column(id=13)
    protected String subject;
    @Column(id=14, notNull=false)
    protected String topic;
    @Column(id=17, notNull=false)
    protected String originalSubject;
    @Column(id=18, notNull=false)
    protected String submissionId;
    @Column(id=19, notNull=false)
    protected Account.Id assignee;
    @Column(id=20)
    protected boolean isPrivate;
    @Column(id=21)
    protected boolean workInProgress;
    @Column(id=22)
    protected boolean reviewStarted;
    @Column(id=23, notNull=false)
    protected Id revertOf;
    @Column(id=101, notNull=false, length=0x7FFFFFFF)
    protected String noteDbState;

    protected Change() {
    }

    public Change(Key newKey, Id newId, Account.Id ownedBy, Branch.NameKey forBranch, Timestamp ts) {
        this.changeKey = newKey;
        this.changeId = newId;
        this.lastUpdatedOn = this.createdOn = ts;
        this.owner = ownedBy;
        this.dest = forBranch;
        this.setStatus(Status.NEW);
    }

    public Change(Change other) {
        this.assignee = other.assignee;
        this.changeId = other.changeId;
        this.changeKey = other.changeKey;
        this.rowVersion = other.rowVersion;
        this.createdOn = other.createdOn;
        this.lastUpdatedOn = other.lastUpdatedOn;
        this.owner = other.owner;
        this.dest = other.dest;
        this.status = other.status;
        this.currentPatchSetId = other.currentPatchSetId;
        this.subject = other.subject;
        this.originalSubject = other.originalSubject;
        this.submissionId = other.submissionId;
        this.topic = other.topic;
        this.isPrivate = other.isPrivate;
        this.workInProgress = other.workInProgress;
        this.reviewStarted = other.reviewStarted;
        this.noteDbState = other.noteDbState;
        this.revertOf = other.revertOf;
    }

    public Id getId() {
        return this.changeId;
    }

    public int getChangeId() {
        return this.changeId.get();
    }

    public Key getKey() {
        return this.changeKey;
    }

    public void setKey(Key k) {
        this.changeKey = k;
    }

    public Account.Id getAssignee() {
        return this.assignee;
    }

    public void setAssignee(Account.Id a) {
        this.assignee = a;
    }

    public Timestamp getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Timestamp ts) {
        this.createdOn = ts;
    }

    public Timestamp getLastUpdatedOn() {
        return this.lastUpdatedOn;
    }

    public void setLastUpdatedOn(Timestamp now) {
        this.lastUpdatedOn = now;
    }

    public int getRowVersion() {
        return this.rowVersion;
    }

    public Account.Id getOwner() {
        return this.owner;
    }

    public void setOwner(Account.Id owner) {
        this.owner = owner;
    }

    public Branch.NameKey getDest() {
        return this.dest;
    }

    public void setDest(Branch.NameKey dest) {
        this.dest = dest;
    }

    public Project.NameKey getProject() {
        return this.dest.getParentKey();
    }

    public String getSubject() {
        return this.subject;
    }

    public String getOriginalSubject() {
        return this.originalSubject != null ? this.originalSubject : this.subject;
    }

    public String getOriginalSubjectOrNull() {
        return this.originalSubject;
    }

    public PatchSet.Id currentPatchSetId() {
        if (this.currentPatchSetId > 0) {
            return new PatchSet.Id(this.changeId, this.currentPatchSetId);
        }
        return null;
    }

    public void setCurrentPatchSet(PatchSetInfo ps) {
        if (this.originalSubject == null && this.subject != null) {
            this.originalSubject = this.subject;
        }
        this.currentPatchSetId = ps.getKey().get();
        this.subject = ps.getSubject();
        if (this.originalSubject == null) {
            this.originalSubject = this.subject;
        }
    }

    public void setCurrentPatchSet(PatchSet.Id psId, String subject, String originalSubject) {
        if (!psId.getParentKey().equals(this.changeId)) {
            throw new IllegalArgumentException("patch set ID " + psId + " is not for change " + this.changeId);
        }
        this.currentPatchSetId = psId.get();
        this.subject = subject;
        this.originalSubject = originalSubject;
    }

    public void clearCurrentPatchSet() {
        this.currentPatchSetId = 0;
        this.subject = null;
        this.originalSubject = null;
    }

    public String getSubmissionId() {
        return this.submissionId;
    }

    public void setSubmissionId(String id) {
        this.submissionId = id;
    }

    public Status getStatus() {
        return Status.forCode(this.status);
    }

    public void setStatus(Status newStatus) {
        this.status = newStatus.getCode();
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public void setPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    public boolean isWorkInProgress() {
        return this.workInProgress;
    }

    public void setWorkInProgress(boolean workInProgress) {
        this.workInProgress = workInProgress;
    }

    public boolean hasReviewStarted() {
        return this.reviewStarted;
    }

    public void setReviewStarted(boolean reviewStarted) {
        this.reviewStarted = reviewStarted;
    }

    public void setRevertOf(Id revertOf) {
        this.revertOf = revertOf;
    }

    public Id getRevertOf() {
        return this.revertOf;
    }

    public String getNoteDbState() {
        return this.noteDbState;
    }

    public void setNoteDbState(String state) {
        this.noteDbState = state;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + this.changeId + " (" + this.changeKey + "), " + "dest=" + this.dest + ", " + "status=" + this.status + '}';
    }

    public static enum Status {
        NEW('n', ChangeStatus.NEW),
        MERGED('M', ChangeStatus.MERGED),
        ABANDONED('A', ChangeStatus.ABANDONED);

        private final char code;
        private final boolean closed;
        private final ChangeStatus changeStatus;

        private Status(char c, ChangeStatus cs) {
            this.code = c;
            this.closed = 'a' > c || c > 'z';
            this.changeStatus = cs;
        }

        public char getCode() {
            return this.code;
        }

        public boolean isOpen() {
            return !this.closed;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public ChangeStatus asChangeStatus() {
            return this.changeStatus;
        }

        public static Status forCode(char c) {
            for (Status s : Status.values()) {
                if (s.code != c) continue;
                return s;
            }
            if (c == 'd') {
                return NEW;
            }
            return null;
        }

        public static Status forChangeStatus(ChangeStatus cs) {
            for (Status s : Status.values()) {
                if (s.changeStatus != cs) continue;
                return s;
            }
            return null;
        }

        static {
            boolean ok = true;
            if (Status.values().length != ChangeStatus.values().length) {
                ok = false;
            }
            for (Status s : Status.values()) {
                ok &= s.name().equals(s.changeStatus.name());
            }
            if (!ok) {
                throw new IllegalStateException("Mismatched status mapping: " + Arrays.asList(Status.values()) + " != " + Arrays.asList(ChangeStatus.values()));
            }
        }
    }

    public static class Key
    extends StringKey<com.google.gwtorm.client.Key<?>> {
        private static final long serialVersionUID = 1L;
        @Column(id=1, length=60)
        protected String id;

        protected Key() {
        }

        public Key(String id) {
            this.id = id;
        }

        @Override
        public String get() {
            return this.id;
        }

        @Override
        protected void set(String newValue) {
            this.id = newValue;
        }

        public Key max() {
            StringBuilder revEnd = new StringBuilder(this.get().length() + 1);
            revEnd.append(this.get());
            revEnd.append('\u9fa5');
            return new Key(revEnd.toString());
        }

        public String abbreviate() {
            String s = this.get();
            return s.substring(0, Math.min(s.length(), 9));
        }

        public static Key parse(String str) {
            Key r = new Key();
            r.fromString(str);
            return r;
        }
    }

    public static class Id
    extends IntKey<com.google.gwtorm.client.Key<?>> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        public int id;

        protected Id() {
        }

        public Id(int id) {
            this.id = id;
        }

        @Override
        public int get() {
            return this.id;
        }

        @Override
        protected void set(int newValue) {
            this.id = newValue;
        }

        public String toRefPrefix() {
            return this.refPrefixBuilder().toString();
        }

        StringBuilder refPrefixBuilder() {
            StringBuilder r = new StringBuilder(32).append("refs/changes/");
            int m = this.id % 100;
            if (m < 10) {
                r.append('0');
            }
            return r.append(m).append('/').append(this.id).append('/');
        }

        public static Id parse(String str) {
            Id r = new Id();
            r.fromString(str);
            return r;
        }

        public static Id fromRef(String ref) {
            if (RefNames.isRefsEdit(ref)) {
                return Id.fromEditRefPart(ref);
            }
            int cs = Id.startIndex(ref);
            if (cs < 0) {
                return null;
            }
            int ce = Id.nextNonDigit(ref, cs);
            if (ref.substring(ce).equals("/meta") || ref.substring(ce).equals("/robot-comments") || PatchSet.Id.fromRef(ref, ce) >= 0) {
                return new Id(Integer.parseInt(ref.substring(cs, ce)));
            }
            return null;
        }

        public static Id fromAllUsersRef(String ref) {
            String prefix;
            if (ref == null) {
                return null;
            }
            if (ref.startsWith("refs/starred-changes/")) {
                prefix = "refs/starred-changes/";
            } else if (ref.startsWith("refs/draft-comments/")) {
                prefix = "refs/draft-comments/";
            } else {
                return null;
            }
            int cs = Id.startIndex(ref, prefix);
            if (cs < 0) {
                return null;
            }
            int ce = Id.nextNonDigit(ref, cs);
            if (ce < ref.length() && ref.charAt(ce) == '/' && Id.isNumeric(ref, ce + 1)) {
                return new Id(Integer.parseInt(ref.substring(cs, ce)));
            }
            return null;
        }

        private static boolean isNumeric(String s, int off) {
            if (off >= s.length()) {
                return false;
            }
            for (int i = off; i < s.length(); ++i) {
                if (Character.isDigit(s.charAt(i))) continue;
                return false;
            }
            return true;
        }

        public static Id fromEditRefPart(String ref) {
            int endChangeId;
            int startChangeId = ref.indexOf("edit-") + "edit-".length();
            String id = ref.substring(startChangeId, endChangeId = Id.nextNonDigit(ref, startChangeId));
            if (id != null && !id.isEmpty()) {
                return new Id(Integer.parseInt(id));
            }
            return null;
        }

        public static Id fromRefPart(String ref) {
            Integer id = RefNames.parseShardedRefPart(ref);
            return id != null ? new Id(id) : null;
        }

        static int startIndex(String ref) {
            return Id.startIndex(ref, "refs/changes/");
        }

        static int startIndex(String ref, String expectedPrefix) {
            if (ref == null || !ref.startsWith(expectedPrefix)) {
                return -1;
            }
            int ls = expectedPrefix.length();
            int le = Id.nextNonDigit(ref, ls);
            if (le - ls != 2 || le >= ref.length() || ref.charAt(le) != '/') {
                return -1;
            }
            int cs = le + 1;
            if (cs >= ref.length() || ref.charAt(cs) == '0') {
                return -1;
            }
            int ce = Id.nextNonDigit(ref, cs);
            if (ce >= ref.length() || ref.charAt(ce) != '/') {
                return -1;
            }
            switch (ce - cs) {
                case 0: {
                    return -1;
                }
                case 1: {
                    if (ref.charAt(ls) == '0' && ref.charAt(ls + 1) == ref.charAt(cs)) break;
                    return -1;
                }
                default: {
                    if (ref.charAt(ls) == ref.charAt(ce - 2) && ref.charAt(ls + 1) == ref.charAt(ce - 1)) break;
                    return -1;
                }
            }
            return cs;
        }

        static int nextNonDigit(String s, int i) {
            while (i < s.length() && s.charAt(i) >= '0' && s.charAt(i) <= '9') {
                ++i;
            }
            return i;
        }
    }
}

