/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.api.config.ConsistencyCheckInfo;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.account.Accounts;
import com.google.gerrit.server.account.externalids.ExternalIds;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Singleton
public class AccountsConsistencyChecker {
    private final Accounts accounts;
    private final ExternalIds externalIds;

    @Inject
    AccountsConsistencyChecker(Accounts accounts, ExternalIds externalIds) {
        this.accounts = accounts;
        this.externalIds = externalIds;
    }

    public List<ConsistencyCheckInfo.ConsistencyProblemInfo> check() throws IOException {
        ArrayList<ConsistencyCheckInfo.ConsistencyProblemInfo> problems = new ArrayList<ConsistencyCheckInfo.ConsistencyProblemInfo>();
        for (Account account : this.accounts.all()) {
            if (account.getPreferredEmail() == null || this.externalIds.byAccount(account.getId()).stream().anyMatch(e -> account.getPreferredEmail().equals(e.email()))) continue;
            AccountsConsistencyChecker.addError(String.format("Account '%s' has no external ID for its preferred email '%s'", account.getId().get(), account.getPreferredEmail()), problems);
        }
        return problems;
    }

    private static void addError(String error, List<ConsistencyCheckInfo.ConsistencyProblemInfo> problems) {
        problems.add(new ConsistencyCheckInfo.ConsistencyProblemInfo(ConsistencyCheckInfo.ConsistencyProblemInfo.Status.ERROR, error));
    }
}

