/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.client.AccountFieldName;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountException;
import com.google.gerrit.server.account.AccountManager;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.Realm;
import com.google.gerrit.server.account.externalids.ExternalIds;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;

@Singleton
public class DeleteEmail
implements RestModifyView<AccountResource.Email, Input> {
    private final Provider<CurrentUser> self;
    private final Realm realm;
    private final PermissionBackend permissionBackend;
    private final AccountManager accountManager;
    private final ExternalIds externalIds;

    @Inject
    DeleteEmail(Provider<CurrentUser> self, Realm realm, PermissionBackend permissionBackend, AccountManager accountManager, ExternalIds externalIds) {
        this.self = self;
        this.realm = realm;
        this.permissionBackend = permissionBackend;
        this.accountManager = accountManager;
        this.externalIds = externalIds;
    }

    public Response<?> apply(AccountResource.Email rsrc, Input input) throws AuthException, ResourceNotFoundException, ResourceConflictException, MethodNotAllowedException, OrmException, IOException, ConfigInvalidException, PermissionBackendException {
        if (!this.self.get().hasSameAccountId(rsrc.getUser())) {
            this.permissionBackend.user(this.self).check(GlobalPermission.MODIFY_ACCOUNT);
        }
        return this.apply(rsrc.getUser(), rsrc.getEmail());
    }

    public Response<?> apply(IdentifiedUser user, String email) throws ResourceNotFoundException, ResourceConflictException, MethodNotAllowedException, OrmException, IOException, ConfigInvalidException {
        if (!this.realm.allowsEdit(AccountFieldName.REGISTER_NEW_EMAIL)) {
            throw new MethodNotAllowedException("realm does not allow deleting emails");
        }
        Set extIds = this.externalIds.byAccount(user.getAccountId()).stream().filter(e -> email.equals(e.email())).collect(Collectors.toSet());
        if (extIds.isEmpty()) {
            throw new ResourceNotFoundException(email);
        }
        try {
            this.accountManager.unlink(user.getAccountId(), extIds.stream().map(e -> e.key()).collect(Collectors.toSet()));
        }
        catch (AccountException e2) {
            throw new ResourceConflictException(e2.getMessage());
        }
        return Response.none();
    }

    public static class Input {
    }
}

