/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.client.ProjectWatchInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.WatchConfig;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;

@Singleton
public class DeleteWatchedProjects
implements RestModifyView<AccountResource, List<ProjectWatchInfo>> {
    private final Provider<IdentifiedUser> self;
    private final PermissionBackend permissionBackend;
    private final AccountCache accountCache;
    private final WatchConfig.Accessor watchConfig;

    @Inject
    DeleteWatchedProjects(Provider<IdentifiedUser> self, PermissionBackend permissionBackend, AccountCache accountCache, WatchConfig.Accessor watchConfig) {
        this.self = self;
        this.permissionBackend = permissionBackend;
        this.accountCache = accountCache;
        this.watchConfig = watchConfig;
    }

    public Response<?> apply(AccountResource rsrc, List<ProjectWatchInfo> input) throws AuthException, UnprocessableEntityException, OrmException, IOException, ConfigInvalidException, PermissionBackendException {
        if (!this.self.get().hasSameAccountId(rsrc.getUser())) {
            this.permissionBackend.user(this.self).check(GlobalPermission.ADMINISTRATE_SERVER);
        }
        if (input == null) {
            return Response.none();
        }
        Account.Id accountId = rsrc.getUser().getAccountId();
        this.watchConfig.deleteProjectWatches(accountId, input.stream().filter(Objects::nonNull).map(w -> WatchConfig.ProjectWatchKey.create(new Project.NameKey(w.project), w.filter)).collect(Collectors.toList()));
        this.accountCache.evict(accountId);
        return Response.none();
    }
}

