/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.account.GroupIncludeCache;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gerrit.server.group.Groups;
import com.google.gerrit.server.group.InternalGroup;
import com.google.gerrit.server.index.group.GroupField;
import com.google.gerrit.server.index.group.GroupIndex;
import com.google.gerrit.server.index.group.GroupIndexCollection;
import com.google.gerrit.server.query.group.InternalGroupQuery;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GroupIncludeCacheImpl
implements GroupIncludeCache {
    private static final Logger log = LoggerFactory.getLogger(GroupIncludeCacheImpl.class);
    private static final String PARENT_GROUPS_NAME = "groups_bysubgroup";
    private static final String SUBGROUPS_NAME = "groups_subgroups";
    private static final String GROUPS_WITH_MEMBER_NAME = "groups_bymember";
    private static final String EXTERNAL_NAME = "groups_external";
    private final LoadingCache<Account.Id, ImmutableSet<AccountGroup.UUID>> groupsWithMember;
    private final LoadingCache<AccountGroup.UUID, ImmutableList<AccountGroup.UUID>> subgroups;
    private final LoadingCache<AccountGroup.UUID, ImmutableList<AccountGroup.UUID>> parentGroups;
    private final LoadingCache<String, ImmutableList<AccountGroup.UUID>> external;

    public static Module module() {
        return new CacheModule(){

            @Override
            protected void configure() {
                this.cache(GroupIncludeCacheImpl.GROUPS_WITH_MEMBER_NAME, Account.Id.class, new TypeLiteral<ImmutableSet<AccountGroup.UUID>>(){}).loader(GroupsWithMemberLoader.class);
                this.cache(GroupIncludeCacheImpl.PARENT_GROUPS_NAME, AccountGroup.UUID.class, new TypeLiteral<ImmutableList<AccountGroup.UUID>>(){}).loader(ParentGroupsLoader.class);
                this.cache(GroupIncludeCacheImpl.SUBGROUPS_NAME, AccountGroup.UUID.class, new TypeLiteral<ImmutableList<AccountGroup.UUID>>(){}).loader(SubgroupsLoader.class);
                this.cache(GroupIncludeCacheImpl.EXTERNAL_NAME, String.class, new TypeLiteral<ImmutableList<AccountGroup.UUID>>(){}).loader(AllExternalLoader.class);
                this.bind(GroupIncludeCacheImpl.class);
                this.bind(GroupIncludeCache.class).to(GroupIncludeCacheImpl.class);
            }
        };
    }

    @Inject
    GroupIncludeCacheImpl(@Named(value="groups_bymember") LoadingCache<Account.Id, ImmutableSet<AccountGroup.UUID>> groupsWithMember, @Named(value="groups_subgroups") LoadingCache<AccountGroup.UUID, ImmutableList<AccountGroup.UUID>> subgroups, @Named(value="groups_bysubgroup") LoadingCache<AccountGroup.UUID, ImmutableList<AccountGroup.UUID>> parentGroups, @Named(value="groups_external") LoadingCache<String, ImmutableList<AccountGroup.UUID>> external) {
        this.groupsWithMember = groupsWithMember;
        this.subgroups = subgroups;
        this.parentGroups = parentGroups;
        this.external = external;
    }

    @Override
    public Collection<AccountGroup.UUID> getGroupsWithMember(Account.Id memberId) {
        try {
            return this.groupsWithMember.get(memberId);
        }
        catch (ExecutionException e) {
            log.warn("Cannot load groups containing {} as member", (Object)memberId.get());
            return ImmutableSet.of();
        }
    }

    @Override
    public Collection<AccountGroup.UUID> subgroupsOf(AccountGroup.UUID groupId) {
        try {
            return this.subgroups.get(groupId);
        }
        catch (ExecutionException e) {
            log.warn("Cannot load members of group", e);
            return Collections.emptySet();
        }
    }

    @Override
    public Collection<AccountGroup.UUID> parentGroupsOf(AccountGroup.UUID groupId) {
        try {
            return this.parentGroups.get(groupId);
        }
        catch (ExecutionException e) {
            log.warn("Cannot load included groups", e);
            return Collections.emptySet();
        }
    }

    @Override
    public void evictGroupsWithMember(Account.Id memberId) {
        if (memberId != null) {
            this.groupsWithMember.invalidate(memberId);
        }
    }

    @Override
    public void evictSubgroupsOf(AccountGroup.UUID groupId) {
        if (groupId != null) {
            this.subgroups.invalidate(groupId);
        }
    }

    @Override
    public void evictParentGroupsOf(AccountGroup.UUID groupId) {
        if (groupId != null) {
            this.parentGroups.invalidate(groupId);
            if (!AccountGroup.isInternalGroup(groupId)) {
                this.external.invalidate(EXTERNAL_NAME);
            }
        }
    }

    @Override
    public Collection<AccountGroup.UUID> allExternalMembers() {
        try {
            return this.external.get(EXTERNAL_NAME);
        }
        catch (ExecutionException e) {
            log.warn("Cannot load set of non-internal groups", e);
            return ImmutableList.of();
        }
    }

    static class AllExternalLoader
    extends CacheLoader<String, ImmutableList<AccountGroup.UUID>> {
        private final SchemaFactory<ReviewDb> schema;
        private final Groups groups;

        @Inject
        AllExternalLoader(SchemaFactory<ReviewDb> sf, Groups groups) {
            this.schema = sf;
            this.groups = groups;
        }

        @Override
        public ImmutableList<AccountGroup.UUID> load(String key) throws Exception {
            try (ReviewDb db = this.schema.open();){
                ImmutableList<AccountGroup.UUID> immutableList = this.groups.getExternalGroups(db).collect(ImmutableList.toImmutableList());
                return immutableList;
            }
        }
    }

    static class ParentGroupsLoader
    extends CacheLoader<AccountGroup.UUID, ImmutableList<AccountGroup.UUID>> {
        private final SchemaFactory<ReviewDb> schema;
        private final Provider<GroupIndex> groupIndexProvider;
        private final Provider<InternalGroupQuery> groupQueryProvider;
        private final GroupCache groupCache;

        @Inject
        ParentGroupsLoader(SchemaFactory<ReviewDb> sf, GroupIndexCollection groupIndexCollection, Provider<InternalGroupQuery> groupQueryProvider, GroupCache groupCache) {
            this.schema = sf;
            this.groupIndexProvider = groupIndexCollection::getSearchIndex;
            this.groupQueryProvider = groupQueryProvider;
            this.groupCache = groupCache;
        }

        @Override
        public ImmutableList<AccountGroup.UUID> load(AccountGroup.UUID key) throws OrmException {
            GroupIndex groupIndex = this.groupIndexProvider.get();
            if (groupIndex != null && groupIndex.getSchema().hasField(GroupField.SUBGROUP)) {
                return this.groupQueryProvider.get().bySubgroup(key).stream().map(InternalGroup::getGroupUUID).collect(ImmutableList.toImmutableList());
            }
            try (ReviewDb db = this.schema.open();){
                ImmutableList<AccountGroup.UUID> immutableList = Groups.getParentGroupsFromReviewDb(db, key).map(this.groupCache::get).flatMap(Streams::stream).map(InternalGroup::getGroupUUID).collect(ImmutableList.toImmutableList());
                return immutableList;
            }
        }
    }

    static class SubgroupsLoader
    extends CacheLoader<AccountGroup.UUID, ImmutableList<AccountGroup.UUID>> {
        private final SchemaFactory<ReviewDb> schema;
        private final Groups groups;

        @Inject
        SubgroupsLoader(SchemaFactory<ReviewDb> sf, Groups groups) {
            this.schema = sf;
            this.groups = groups;
        }

        @Override
        public ImmutableList<AccountGroup.UUID> load(AccountGroup.UUID key) throws OrmException, NoSuchGroupException {
            try (ReviewDb db = this.schema.open();){
                ImmutableList<AccountGroup.UUID> immutableList = this.groups.getSubgroups(db, key).collect(ImmutableList.toImmutableList());
                return immutableList;
            }
        }
    }

    static class GroupsWithMemberLoader
    extends CacheLoader<Account.Id, ImmutableSet<AccountGroup.UUID>> {
        private final SchemaFactory<ReviewDb> schema;
        private final Provider<GroupIndex> groupIndexProvider;
        private final Provider<InternalGroupQuery> groupQueryProvider;
        private final GroupCache groupCache;

        @Inject
        GroupsWithMemberLoader(SchemaFactory<ReviewDb> schema, GroupIndexCollection groupIndexCollection, Provider<InternalGroupQuery> groupQueryProvider, GroupCache groupCache) {
            this.schema = schema;
            this.groupIndexProvider = groupIndexCollection::getSearchIndex;
            this.groupQueryProvider = groupQueryProvider;
            this.groupCache = groupCache;
        }

        @Override
        public ImmutableSet<AccountGroup.UUID> load(Account.Id memberId) throws OrmException, NoSuchGroupException {
            GroupIndex groupIndex = this.groupIndexProvider.get();
            if (groupIndex != null && groupIndex.getSchema().hasField(GroupField.MEMBER)) {
                return this.groupQueryProvider.get().byMember(memberId).stream().map(InternalGroup::getGroupUUID).collect(ImmutableSet.toImmutableSet());
            }
            try (ReviewDb db = this.schema.open();){
                ImmutableSet<AccountGroup.UUID> immutableSet = Groups.getGroupsWithMemberFromReviewDb(db, memberId).map(this.groupCache::get).flatMap(Streams::stream).map(InternalGroup::getGroupUUID).collect(ImmutableSet.toImmutableSet());
                return immutableSet;
            }
        }
    }
}

