/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.changes;

import com.google.gerrit.extensions.api.changes.FileApi;
import com.google.gerrit.extensions.common.DiffInfo;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.server.api.ApiUtil;
import com.google.gerrit.server.change.FileResource;
import com.google.gerrit.server.change.GetContent;
import com.google.gerrit.server.change.GetDiff;
import com.google.gerrit.server.change.Reviewed;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;

class FileApiImpl
implements FileApi {
    private final GetContent getContent;
    private final GetDiff getDiff;
    private final Reviewed.PutReviewed putReviewed;
    private final Reviewed.DeleteReviewed deleteReviewed;
    private final FileResource file;

    @Inject
    FileApiImpl(GetContent getContent, GetDiff getDiff, Reviewed.PutReviewed putReviewed, Reviewed.DeleteReviewed deleteReviewed, @Assisted FileResource file) {
        this.getContent = getContent;
        this.getDiff = getDiff;
        this.putReviewed = putReviewed;
        this.deleteReviewed = deleteReviewed;
        this.file = file;
    }

    @Override
    public BinaryResult content() throws RestApiException {
        try {
            return this.getContent.apply(this.file);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot retrieve file content", e);
        }
    }

    @Override
    public DiffInfo diff() throws RestApiException {
        try {
            return this.getDiff.apply(this.file).value();
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot retrieve diff", e);
        }
    }

    @Override
    public DiffInfo diff(String base) throws RestApiException {
        try {
            return this.getDiff.setBase(base).apply(this.file).value();
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot retrieve diff", e);
        }
    }

    @Override
    public DiffInfo diff(int parent) throws RestApiException {
        try {
            return this.getDiff.setParent(parent).apply(this.file).value();
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot retrieve diff", e);
        }
    }

    @Override
    public FileApi.DiffRequest diffRequest() {
        return new FileApi.DiffRequest(){

            @Override
            public DiffInfo get() throws RestApiException {
                return FileApiImpl.this.get(this);
            }
        };
    }

    @Override
    public void setReviewed(boolean reviewed) throws RestApiException {
        try {
            if (reviewed) {
                this.putReviewed.apply(this.file, new Reviewed.Input());
            } else {
                this.deleteReviewed.apply(this.file, new Reviewed.Input());
            }
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException(String.format("Cannot set %sreviewed", reviewed ? "" : "un"), e);
        }
    }

    private DiffInfo get(FileApi.DiffRequest r) throws RestApiException {
        if (r.getBase() != null) {
            this.getDiff.setBase(r.getBase());
        }
        if (r.getContext() != null) {
            this.getDiff.setContext(r.getContext());
        }
        if (r.getIntraline() != null) {
            this.getDiff.setIntraline(r.getIntraline());
        }
        if (r.getWhitespace() != null) {
            this.getDiff.setWhitespace(r.getWhitespace());
        }
        r.getParent().ifPresent(this.getDiff::setParent);
        try {
            return this.getDiff.apply(this.file).value();
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot retrieve diff", e);
        }
    }

    static interface Factory {
        public FileApiImpl create(FileResource var1);
    }
}

