/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.changes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gerrit.extensions.api.changes.ChangeApi;
import com.google.gerrit.extensions.api.changes.Changes;
import com.google.gerrit.extensions.api.changes.CherryPickInput;
import com.google.gerrit.extensions.api.changes.CommentApi;
import com.google.gerrit.extensions.api.changes.DraftApi;
import com.google.gerrit.extensions.api.changes.DraftInput;
import com.google.gerrit.extensions.api.changes.FileApi;
import com.google.gerrit.extensions.api.changes.RebaseInput;
import com.google.gerrit.extensions.api.changes.RelatedChangesInfo;
import com.google.gerrit.extensions.api.changes.ReviewInput;
import com.google.gerrit.extensions.api.changes.ReviewResult;
import com.google.gerrit.extensions.api.changes.RevisionApi;
import com.google.gerrit.extensions.api.changes.RevisionReviewerApi;
import com.google.gerrit.extensions.api.changes.RobotCommentApi;
import com.google.gerrit.extensions.api.changes.SubmitInput;
import com.google.gerrit.extensions.client.SubmitType;
import com.google.gerrit.extensions.common.ActionInfo;
import com.google.gerrit.extensions.common.ApprovalInfo;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.CommentInfo;
import com.google.gerrit.extensions.common.CommitInfo;
import com.google.gerrit.extensions.common.EditInfo;
import com.google.gerrit.extensions.common.FileInfo;
import com.google.gerrit.extensions.common.MergeableInfo;
import com.google.gerrit.extensions.common.RobotCommentInfo;
import com.google.gerrit.extensions.common.TestSubmitRuleInput;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.account.AccountDirectory;
import com.google.gerrit.server.account.AccountLoader;
import com.google.gerrit.server.api.ApiUtil;
import com.google.gerrit.server.api.changes.CommentApiImpl;
import com.google.gerrit.server.api.changes.DraftApiImpl;
import com.google.gerrit.server.api.changes.FileApiImpl;
import com.google.gerrit.server.api.changes.RevisionReviewerApiImpl;
import com.google.gerrit.server.api.changes.RobotCommentApiImpl;
import com.google.gerrit.server.change.ApplyFix;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.CherryPick;
import com.google.gerrit.server.change.Comments;
import com.google.gerrit.server.change.CreateDraftComment;
import com.google.gerrit.server.change.DraftComments;
import com.google.gerrit.server.change.FileResource;
import com.google.gerrit.server.change.Files;
import com.google.gerrit.server.change.Fixes;
import com.google.gerrit.server.change.GetCommit;
import com.google.gerrit.server.change.GetDescription;
import com.google.gerrit.server.change.GetMergeList;
import com.google.gerrit.server.change.GetPatch;
import com.google.gerrit.server.change.GetRelated;
import com.google.gerrit.server.change.GetRevisionActions;
import com.google.gerrit.server.change.ListRevisionComments;
import com.google.gerrit.server.change.ListRevisionDrafts;
import com.google.gerrit.server.change.ListRobotComments;
import com.google.gerrit.server.change.Mergeable;
import com.google.gerrit.server.change.PostReview;
import com.google.gerrit.server.change.PreviewSubmit;
import com.google.gerrit.server.change.PutDescription;
import com.google.gerrit.server.change.Rebase;
import com.google.gerrit.server.change.RebaseUtil;
import com.google.gerrit.server.change.Reviewed;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.change.RevisionReviewers;
import com.google.gerrit.server.change.RobotComments;
import com.google.gerrit.server.change.Submit;
import com.google.gerrit.server.change.TestSubmitType;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;

class RevisionApiImpl
implements RevisionApi {
    private final GitRepositoryManager repoManager;
    private final Changes changes;
    private final RevisionReviewers revisionReviewers;
    private final RevisionReviewerApiImpl.Factory revisionReviewerApi;
    private final CherryPick cherryPick;
    private final Rebase rebase;
    private final RebaseUtil rebaseUtil;
    private final Submit submit;
    private final PreviewSubmit submitPreview;
    private final Reviewed.PutReviewed putReviewed;
    private final Reviewed.DeleteReviewed deleteReviewed;
    private final RevisionResource revision;
    private final Files files;
    private final Files.ListFiles listFiles;
    private final GetCommit getCommit;
    private final GetPatch getPatch;
    private final PostReview review;
    private final Mergeable mergeable;
    private final FileApiImpl.Factory fileApi;
    private final ListRevisionComments listComments;
    private final ListRobotComments listRobotComments;
    private final ApplyFix applyFix;
    private final Fixes fixes;
    private final ListRevisionDrafts listDrafts;
    private final CreateDraftComment createDraft;
    private final DraftComments drafts;
    private final DraftApiImpl.Factory draftFactory;
    private final Comments comments;
    private final CommentApiImpl.Factory commentFactory;
    private final RobotComments robotComments;
    private final RobotCommentApiImpl.Factory robotCommentFactory;
    private final GetRevisionActions revisionActions;
    private final TestSubmitType testSubmitType;
    private final TestSubmitType.Get getSubmitType;
    private final Provider<GetMergeList> getMergeList;
    private final GetRelated getRelated;
    private final PutDescription putDescription;
    private final GetDescription getDescription;
    private final ApprovalsUtil approvalsUtil;
    private final Provider<ReviewDb> db;
    private final AccountLoader.Factory accountLoaderFactory;

    @Inject
    RevisionApiImpl(GitRepositoryManager repoManager, Changes changes, RevisionReviewers revisionReviewers, RevisionReviewerApiImpl.Factory revisionReviewerApi, CherryPick cherryPick, Rebase rebase, RebaseUtil rebaseUtil, Submit submit, PreviewSubmit submitPreview, Reviewed.PutReviewed putReviewed, Reviewed.DeleteReviewed deleteReviewed, Files files, Files.ListFiles listFiles, GetCommit getCommit, GetPatch getPatch, PostReview review, Mergeable mergeable, FileApiImpl.Factory fileApi, ListRevisionComments listComments, ListRobotComments listRobotComments, ApplyFix applyFix, Fixes fixes, ListRevisionDrafts listDrafts, CreateDraftComment createDraft, DraftComments drafts, DraftApiImpl.Factory draftFactory, Comments comments, CommentApiImpl.Factory commentFactory, RobotComments robotComments, RobotCommentApiImpl.Factory robotCommentFactory, GetRevisionActions revisionActions, TestSubmitType testSubmitType, TestSubmitType.Get getSubmitType, Provider<GetMergeList> getMergeList, GetRelated getRelated, PutDescription putDescription, GetDescription getDescription, ApprovalsUtil approvalsUtil, Provider<ReviewDb> db, AccountLoader.Factory accountLoaderFactory, @Assisted RevisionResource r) {
        this.repoManager = repoManager;
        this.changes = changes;
        this.revisionReviewers = revisionReviewers;
        this.revisionReviewerApi = revisionReviewerApi;
        this.cherryPick = cherryPick;
        this.rebase = rebase;
        this.rebaseUtil = rebaseUtil;
        this.review = review;
        this.submit = submit;
        this.submitPreview = submitPreview;
        this.files = files;
        this.putReviewed = putReviewed;
        this.deleteReviewed = deleteReviewed;
        this.listFiles = listFiles;
        this.getCommit = getCommit;
        this.getPatch = getPatch;
        this.mergeable = mergeable;
        this.fileApi = fileApi;
        this.listComments = listComments;
        this.robotComments = robotComments;
        this.listRobotComments = listRobotComments;
        this.applyFix = applyFix;
        this.fixes = fixes;
        this.listDrafts = listDrafts;
        this.createDraft = createDraft;
        this.drafts = drafts;
        this.draftFactory = draftFactory;
        this.comments = comments;
        this.commentFactory = commentFactory;
        this.robotCommentFactory = robotCommentFactory;
        this.revisionActions = revisionActions;
        this.testSubmitType = testSubmitType;
        this.getSubmitType = getSubmitType;
        this.getMergeList = getMergeList;
        this.getRelated = getRelated;
        this.putDescription = putDescription;
        this.getDescription = getDescription;
        this.approvalsUtil = approvalsUtil;
        this.db = db;
        this.accountLoaderFactory = accountLoaderFactory;
        this.revision = r;
    }

    @Override
    public ReviewResult review(ReviewInput in) throws RestApiException {
        try {
            return (ReviewResult)((Response)this.review.apply(this.revision, in)).value();
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot post review", e);
        }
    }

    @Override
    public void submit() throws RestApiException {
        SubmitInput in = new SubmitInput();
        this.submit(in);
    }

    @Override
    public void submit(SubmitInput in) throws RestApiException {
        try {
            this.submit.apply(this.revision, in);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot submit change", e);
        }
    }

    @Override
    public BinaryResult submitPreview() throws RestApiException {
        return this.submitPreview("zip");
    }

    @Override
    public BinaryResult submitPreview(String format) throws RestApiException {
        try {
            this.submitPreview.setFormat(format);
            return this.submitPreview.apply(this.revision);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot get submit preview", e);
        }
    }

    @Override
    public void publish() throws RestApiException {
        throw new UnsupportedOperationException("draft workflow is discontinued");
    }

    @Override
    public void delete() throws RestApiException {
        throw new UnsupportedOperationException("draft workflow is discontinued");
    }

    @Override
    public ChangeApi rebase() throws RestApiException {
        RebaseInput in = new RebaseInput();
        return this.rebase(in);
    }

    @Override
    public ChangeApi rebase(RebaseInput in) throws RestApiException {
        try {
            return this.changes.id(((ChangeInfo)this.rebase.apply(this.revision, in))._number);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot rebase ps", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean canRebase() throws RestApiException {
        try (Repository repo = this.repoManager.openRepository(this.revision.getProject());){
            RevWalk rw = new RevWalk(repo);
            try {
                boolean bl = this.rebaseUtil.canRebase(this.revision.getPatchSet(), this.revision.getChange().getDest(), repo, rw);
                rw.close();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    rw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot check if rebase is possible", e);
        }
    }

    @Override
    public ChangeApi cherryPick(CherryPickInput in) throws RestApiException {
        try {
            return this.changes.id(((ChangeInfo)this.cherryPick.apply(this.revision, in))._number);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot cherry pick", e);
        }
    }

    @Override
    public RevisionReviewerApi reviewer(String id) throws RestApiException {
        try {
            return this.revisionReviewerApi.create(this.revisionReviewers.parse(this.revision, IdString.fromDecoded(id)));
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot parse reviewer", e);
        }
    }

    @Override
    public void setReviewed(String path, boolean reviewed) throws RestApiException {
        try {
            RestModifyView<FileResource, Reviewed.Input> view = reviewed ? this.putReviewed : this.deleteReviewed;
            view.apply(this.files.parse(this.revision, IdString.fromDecoded(path)), new Reviewed.Input());
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot update reviewed flag", e);
        }
    }

    @Override
    public Set<String> reviewed() throws RestApiException {
        try {
            return ImmutableSet.copyOf((Iterable)this.listFiles.setReviewed(true).apply(this.revision).value());
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot list reviewed files", e);
        }
    }

    @Override
    public MergeableInfo mergeable() throws RestApiException {
        try {
            return this.mergeable.apply(this.revision);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot check mergeability", e);
        }
    }

    @Override
    public MergeableInfo mergeableOtherBranches() throws RestApiException {
        try {
            this.mergeable.setOtherBranches(true);
            return this.mergeable.apply(this.revision);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot check mergeability", e);
        }
    }

    @Override
    public Map<String, FileInfo> files() throws RestApiException {
        try {
            return (Map)this.listFiles.apply(this.revision).value();
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot retrieve files", e);
        }
    }

    @Override
    public Map<String, FileInfo> files(String base) throws RestApiException {
        try {
            return (Map)this.listFiles.setBase(base).apply(this.revision).value();
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot retrieve files", e);
        }
    }

    @Override
    public Map<String, FileInfo> files(int parentNum) throws RestApiException {
        try {
            return (Map)this.listFiles.setParent(parentNum).apply(this.revision).value();
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot retrieve files", e);
        }
    }

    @Override
    public List<String> queryFiles(String query) throws RestApiException {
        try {
            Preconditions.checkArgument(query != null, "no query provided");
            return (List)this.listFiles.setQuery(query).apply(this.revision).value();
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot retrieve files", e);
        }
    }

    @Override
    public FileApi file(String path) {
        return this.fileApi.create(this.files.parse(this.revision, IdString.fromDecoded(path)));
    }

    @Override
    public CommitInfo commit(boolean addLinks) throws RestApiException {
        try {
            return this.getCommit.setAddLinks(addLinks).apply(this.revision).value();
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot retrieve commit", e);
        }
    }

    @Override
    public Map<String, List<CommentInfo>> comments() throws RestApiException {
        try {
            return this.listComments.apply(this.revision);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot retrieve comments", e);
        }
    }

    @Override
    public Map<String, List<RobotCommentInfo>> robotComments() throws RestApiException {
        try {
            return this.listRobotComments.apply(this.revision);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot retrieve robot comments", e);
        }
    }

    @Override
    public List<CommentInfo> commentsAsList() throws RestApiException {
        try {
            return this.listComments.getComments(this.revision);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot retrieve comments", e);
        }
    }

    @Override
    public Map<String, List<CommentInfo>> drafts() throws RestApiException {
        try {
            return this.listDrafts.apply(this.revision);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot retrieve drafts", e);
        }
    }

    @Override
    public List<RobotCommentInfo> robotCommentsAsList() throws RestApiException {
        try {
            return this.listRobotComments.getComments(this.revision);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot retrieve robot comments", e);
        }
    }

    @Override
    public EditInfo applyFix(String fixId) throws RestApiException {
        try {
            return this.applyFix.apply(this.fixes.parse(this.revision, IdString.fromDecoded(fixId)), null).value();
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot apply fix", e);
        }
    }

    @Override
    public List<CommentInfo> draftsAsList() throws RestApiException {
        try {
            return this.listDrafts.getComments(this.revision);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot retrieve drafts", e);
        }
    }

    @Override
    public DraftApi draft(String id) throws RestApiException {
        try {
            return this.draftFactory.create(this.drafts.parse(this.revision, IdString.fromDecoded(id)));
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot retrieve draft", e);
        }
    }

    @Override
    public DraftApi createDraft(DraftInput in) throws RestApiException {
        try {
            String id = ((CommentInfo)((Response)this.createDraft.apply(this.revision, in)).value()).id;
            return this.changes.id(this.revision.getChange().getId().get()).revision(this.revision.getPatchSet().getId().get()).draft(id);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot create draft", e);
        }
    }

    @Override
    public CommentApi comment(String id) throws RestApiException {
        try {
            return this.commentFactory.create(this.comments.parse(this.revision, IdString.fromDecoded(id)));
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot retrieve comment", e);
        }
    }

    @Override
    public RobotCommentApi robotComment(String id) throws RestApiException {
        try {
            return this.robotCommentFactory.create(this.robotComments.parse(this.revision, IdString.fromDecoded(id)));
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot retrieve robot comment", e);
        }
    }

    @Override
    public BinaryResult patch() throws RestApiException {
        try {
            return this.getPatch.apply(this.revision);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot get patch", e);
        }
    }

    @Override
    public BinaryResult patch(String path) throws RestApiException {
        try {
            return this.getPatch.setPath(path).apply(this.revision);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot get patch", e);
        }
    }

    @Override
    public Map<String, ActionInfo> actions() throws RestApiException {
        try {
            return this.revisionActions.apply(this.revision).value();
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot get actions", e);
        }
    }

    @Override
    public SubmitType submitType() throws RestApiException {
        try {
            return this.getSubmitType.apply(this.revision);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot get submit type", e);
        }
    }

    @Override
    public SubmitType testSubmitType(TestSubmitRuleInput in) throws RestApiException {
        try {
            return this.testSubmitType.apply(this.revision, in);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot test submit type", e);
        }
    }

    @Override
    public RevisionApi.MergeListRequest getMergeList() throws RestApiException {
        return new RevisionApi.MergeListRequest(){

            @Override
            public List<CommitInfo> get() throws RestApiException {
                try {
                    GetMergeList gml = (GetMergeList)RevisionApiImpl.this.getMergeList.get();
                    gml.setUninterestingParent(this.getUninterestingParent());
                    gml.setAddLinks(this.getAddLinks());
                    return gml.apply(RevisionApiImpl.this.revision).value();
                }
                catch (Exception e) {
                    throw ApiUtil.asRestApiException("Cannot get merge list", e);
                }
            }
        };
    }

    @Override
    public RelatedChangesInfo related() throws RestApiException {
        try {
            return this.getRelated.apply(this.revision);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot get related changes", e);
        }
    }

    @Override
    public ListMultimap<String, ApprovalInfo> votes() throws RestApiException {
        Multimap result = MultimapBuilder.ListMultimapBuilder.treeKeys().arrayListValues().build();
        try {
            Iterable<PatchSetApproval> approvals = this.approvalsUtil.byPatchSet(this.db.get(), this.revision.getNotes(), this.revision.getChangeResource().getUser(), this.revision.getPatchSet().getId(), null, null);
            AccountLoader accountLoader = this.accountLoaderFactory.create(EnumSet.of(AccountDirectory.FillOptions.ID, AccountDirectory.FillOptions.NAME, AccountDirectory.FillOptions.EMAIL, AccountDirectory.FillOptions.USERNAME));
            for (PatchSetApproval approval : approvals) {
                String label = approval.getLabel();
                ApprovalInfo info = ChangeJson.getApprovalInfo(approval.getAccountId(), Integer.valueOf(approval.getValue()), null, approval.getTag(), approval.getGranted());
                accountLoader.put(info);
                result.get(label).add(info);
            }
            accountLoader.fill();
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot get votes", e);
        }
        return result;
    }

    @Override
    public void description(String description) throws RestApiException {
        PutDescription.Input in = new PutDescription.Input();
        in.description = description;
        try {
            this.putDescription.apply(this.revision, in);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot set description", e);
        }
    }

    @Override
    public String description() throws RestApiException {
        return this.getDescription.apply(this.revision);
    }

    @Override
    public String etag() throws RestApiException {
        return this.revisionActions.getETag(this.revision);
    }

    static interface Factory {
        public RevisionApiImpl create(RevisionResource var1);
    }
}

