/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.cache.h2;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.Weigher;
import com.google.gerrit.server.cache.CacheBinding;
import com.google.gerrit.server.cache.h2.H2CacheImpl;
import com.google.inject.TypeLiteral;
import java.util.concurrent.TimeUnit;

class H2CacheBindingProxy<K, V>
implements CacheBinding<K, V> {
    private static final String MSG_NOT_SUPPORTED = "This is read-only wrapper. Modifications are not supported";
    private final CacheBinding<K, V> source;

    H2CacheBindingProxy(CacheBinding<K, V> source) {
        this.source = source;
    }

    @Override
    public Long expireAfterWrite(TimeUnit unit) {
        return this.source.expireAfterWrite(unit);
    }

    @Override
    public Weigher<K, V> weigher() {
        final Weigher<K, V> weigher = this.source.weigher();
        if (weigher == null) {
            return null;
        }
        return new Weigher<K, H2CacheImpl.ValueHolder<V>>(){

            @Override
            public int weigh(K key, H2CacheImpl.ValueHolder<V> value) {
                return weigher.weigh(key, value.value);
            }
        };
    }

    @Override
    public String name() {
        return this.source.name();
    }

    @Override
    public TypeLiteral<K> keyType() {
        return this.source.keyType();
    }

    @Override
    public TypeLiteral<V> valueType() {
        return this.source.valueType();
    }

    @Override
    public long maximumWeight() {
        return this.source.maximumWeight();
    }

    @Override
    public long diskLimit() {
        return this.source.diskLimit();
    }

    @Override
    public CacheLoader<K, V> loader() {
        return this.source.loader();
    }

    @Override
    public CacheBinding<K, V> maximumWeight(long weight) {
        throw new RuntimeException(MSG_NOT_SUPPORTED);
    }

    @Override
    public CacheBinding<K, V> diskLimit(long limit) {
        throw new RuntimeException(MSG_NOT_SUPPORTED);
    }

    @Override
    public CacheBinding<K, V> expireAfterWrite(long duration, TimeUnit durationUnits) {
        throw new RuntimeException(MSG_NOT_SUPPORTED);
    }

    @Override
    public CacheBinding<K, V> loader(Class<? extends CacheLoader<K, V>> clazz) {
        throw new RuntimeException(MSG_NOT_SUPPORTED);
    }

    @Override
    public CacheBinding<K, V> weigher(Class<? extends Weigher<K, V>> clazz) {
        throw new RuntimeException(MSG_NOT_SUPPORTED);
    }
}

