/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.gerrit.server.change.ArchiveFormat;
import com.google.gerrit.server.config.DownloadConfig;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Set;

@Singleton
public class AllowedFormats {
    final ImmutableMap<String, ArchiveFormat> extensions;
    final ImmutableSet<ArchiveFormat> allowed;

    @Inject
    AllowedFormats(DownloadConfig cfg) {
        HashMap<String, ArchiveFormat> exts = new HashMap<String, ArchiveFormat>();
        for (ArchiveFormat format : cfg.getArchiveFormats()) {
            for (String ext : format.getSuffixes()) {
                exts.put(ext, format);
            }
            exts.put(format.name().toLowerCase(), format);
        }
        this.extensions = ImmutableMap.copyOf(exts);
        this.allowed = Sets.immutableEnumSet(Iterables.filter(cfg.getArchiveFormats(), f -> f != ArchiveFormat.ZIP));
    }

    public Set<ArchiveFormat> getAllowed() {
        return this.allowed;
    }

    public ImmutableMap<String, ArchiveFormat> getExtensions() {
        return this.extensions;
    }
}

