/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.client.Comment;
import com.google.gerrit.extensions.client.Side;
import com.google.gerrit.extensions.common.CommentInfo;
import com.google.gerrit.extensions.common.FixReplacementInfo;
import com.google.gerrit.extensions.common.FixSuggestionInfo;
import com.google.gerrit.extensions.common.RobotCommentInfo;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.FixReplacement;
import com.google.gerrit.reviewdb.client.FixSuggestion;
import com.google.gerrit.reviewdb.client.RobotComment;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.account.AccountLoader;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

class CommentJson {
    private final AccountLoader.Factory accountLoaderFactory;
    private boolean fillAccounts = true;
    private boolean fillPatchSet;

    @Inject
    CommentJson(AccountLoader.Factory accountLoaderFactory) {
        this.accountLoaderFactory = accountLoaderFactory;
    }

    CommentJson setFillAccounts(boolean fillAccounts) {
        this.fillAccounts = fillAccounts;
        return this;
    }

    CommentJson setFillPatchSet(boolean fillPatchSet) {
        this.fillPatchSet = fillPatchSet;
        return this;
    }

    public CommentFormatter newCommentFormatter() {
        return new CommentFormatter();
    }

    public RobotCommentFormatter newRobotCommentFormatter() {
        return new RobotCommentFormatter();
    }

    class RobotCommentFormatter
    extends BaseCommentFormatter<RobotComment, RobotCommentInfo> {
        @Override
        protected RobotCommentInfo toInfo(RobotComment c, AccountLoader loader) {
            RobotCommentInfo rci = new RobotCommentInfo();
            rci.robotId = c.robotId;
            rci.robotRunId = c.robotRunId;
            rci.url = c.url;
            rci.properties = c.properties;
            rci.fixSuggestions = this.toFixSuggestionInfos(c.fixSuggestions);
            this.fillCommentInfo(c, rci, loader);
            return rci;
        }

        private List<FixSuggestionInfo> toFixSuggestionInfos(@Nullable List<FixSuggestion> fixSuggestions) {
            if (fixSuggestions == null || fixSuggestions.isEmpty()) {
                return null;
            }
            return fixSuggestions.stream().map(this::toFixSuggestionInfo).collect(Collectors.toList());
        }

        private FixSuggestionInfo toFixSuggestionInfo(FixSuggestion fixSuggestion) {
            FixSuggestionInfo fixSuggestionInfo = new FixSuggestionInfo();
            fixSuggestionInfo.fixId = fixSuggestion.fixId;
            fixSuggestionInfo.description = fixSuggestion.description;
            fixSuggestionInfo.replacements = fixSuggestion.replacements.stream().map(this::toFixReplacementInfo).collect(Collectors.toList());
            return fixSuggestionInfo;
        }

        private FixReplacementInfo toFixReplacementInfo(FixReplacement fixReplacement) {
            FixReplacementInfo fixReplacementInfo = new FixReplacementInfo();
            fixReplacementInfo.path = fixReplacement.path;
            fixReplacementInfo.range = this.toRange(fixReplacement.range);
            fixReplacementInfo.replacement = fixReplacement.replacement;
            return fixReplacementInfo;
        }

        private RobotCommentFormatter() {
        }
    }

    class CommentFormatter
    extends BaseCommentFormatter<Comment, CommentInfo> {
        @Override
        protected CommentInfo toInfo(Comment c, AccountLoader loader) {
            CommentInfo ci = new CommentInfo();
            this.fillCommentInfo(c, ci, loader);
            return ci;
        }

        private CommentFormatter() {
        }
    }

    private abstract class BaseCommentFormatter<F extends Comment, T extends CommentInfo> {
        private BaseCommentFormatter() {
        }

        public T format(F comment) throws OrmException {
            AccountLoader loader = CommentJson.this.fillAccounts ? CommentJson.this.accountLoaderFactory.create(true) : null;
            T info = this.toInfo(comment, loader);
            if (loader != null) {
                loader.fill();
            }
            return info;
        }

        public Map<String, List<T>> format(Iterable<F> comments) throws OrmException {
            AccountLoader loader = CommentJson.this.fillAccounts ? CommentJson.this.accountLoaderFactory.create(true) : null;
            TreeMap<String, List<T>> out = new TreeMap<String, List<T>>();
            for (Comment c : comments) {
                T o = this.toInfo(c, loader);
                ArrayList<T> list = (ArrayList<T>)out.get(((CommentInfo)o).path);
                if (list == null) {
                    list = new ArrayList<T>();
                    out.put(((CommentInfo)o).path, list);
                }
                ((CommentInfo)o).path = null;
                list.add(o);
            }
            for (List list : out.values()) {
                Collections.sort(list, CommentsUtil.COMMENT_INFO_ORDER);
            }
            if (loader != null) {
                loader.fill();
            }
            return out;
        }

        public List<T> formatAsList(Iterable<F> comments) throws OrmException {
            AccountLoader loader = CommentJson.this.fillAccounts ? CommentJson.this.accountLoaderFactory.create(true) : null;
            ImmutableList<CommentInfo> out = FluentIterable.from(comments).transform(c -> this.toInfo(c, loader)).toSortedList(CommentsUtil.COMMENT_INFO_ORDER);
            if (loader != null) {
                loader.fill();
            }
            return out;
        }

        protected abstract T toInfo(F var1, AccountLoader var2);

        protected void fillCommentInfo(Comment c, CommentInfo r, AccountLoader loader) {
            if (CommentJson.this.fillPatchSet) {
                r.patchSet = c.key.patchSetId;
            }
            r.id = Url.encode(c.key.uuid);
            r.path = c.key.filename;
            if (c.side <= 0) {
                r.side = Side.PARENT;
                if (c.side < 0) {
                    r.parent = -c.side;
                }
            }
            if (c.lineNbr > 0) {
                r.line = c.lineNbr;
            }
            r.inReplyTo = Url.encode(c.parentUuid);
            r.message = Strings.emptyToNull(c.message);
            r.updated = c.writtenOn;
            r.range = this.toRange(c.range);
            r.tag = c.tag;
            r.unresolved = c.unresolved;
            if (loader != null) {
                r.author = loader.get(c.author.getId());
            }
        }

        protected Comment.Range toRange(Comment.Range commentRange) {
            Comment.Range range = null;
            if (commentRange != null) {
                range = new Comment.Range();
                range.startLine = commentRange.startLine;
                range.startCharacter = commentRange.startChar;
                range.endLine = commentRange.endLine;
                range.endCharacter = commentRange.endChar;
            }
            return range;
        }
    }
}

