/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Strings;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.common.data.PatchScript;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.mime.FileTypeRegistry;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import eu.medsea.mimeutil.MimeType;
import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.NB;

@Singleton
public class FileContentUtil {
    public static final String TEXT_X_GERRIT_COMMIT_MESSAGE = "text/x-gerrit-commit-message";
    public static final String TEXT_X_GERRIT_MERGE_LIST = "text/x-gerrit-merge-list";
    private static final String X_GIT_SYMLINK = "x-git/symlink";
    private static final String X_GIT_GITLINK = "x-git/gitlink";
    private static final int MAX_SIZE = 0x500000;
    private static final String ZIP_TYPE = "application/zip";
    private static final SecureRandom rng = new SecureRandom();
    private final GitRepositoryManager repoManager;
    private final FileTypeRegistry registry;

    @Inject
    FileContentUtil(GitRepositoryManager repoManager, FileTypeRegistry ftr) {
        this.repoManager = repoManager;
        this.registry = ftr;
    }

    public BinaryResult getContent(ProjectState project, ObjectId revstr, String path, @Nullable Integer parent) throws BadRequestException, ResourceNotFoundException, IOException {
        try (Repository repo = this.openRepository(project);){
            RevWalk rw = new RevWalk(repo);
            try {
                if (parent != null) {
                    RevCommit revCommit = rw.parseCommit(revstr);
                    if (revCommit == null) {
                        throw new ResourceNotFoundException("commit not found");
                    }
                    if (parent > revCommit.getParentCount()) {
                        throw new BadRequestException("invalid parent");
                    }
                    revstr = rw.parseCommit(revstr).getParent(Integer.max(0, parent - 1)).toObjectId();
                }
                BinaryResult binaryResult = this.getContent(repo, project, revstr, path);
                rw.close();
                return binaryResult;
            }
            catch (Throwable throwable) {
                try {
                    rw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public BinaryResult getContent(Repository repo, ProjectState project, ObjectId revstr, String path) throws IOException, ResourceNotFoundException {
        try (RevWalk rw = new RevWalk(repo);){
            String type;
            byte[] raw;
            ObjectId id;
            FileMode mode;
            TreeWalk tw;
            block20: {
                RevCommit commit = rw.parseCommit(revstr);
                tw = TreeWalk.forPath(rw.getObjectReader(), path, commit.getTree());
                try {
                    if (tw == null) {
                        throw new ResourceNotFoundException();
                    }
                    mode = tw.getFileMode(0);
                    id = tw.getObjectId(0);
                    if (mode != FileMode.GITLINK) break block20;
                    BinaryResult binaryResult = BinaryResult.create(id.name()).setContentType(X_GIT_GITLINK).base64();
                    if (tw != null) {
                        tw.close();
                    }
                    return binaryResult;
                }
                catch (Throwable throwable) {
                    if (tw != null) {
                        try {
                            tw.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            ObjectLoader obj = repo.open(id, 3);
            try {
                raw = obj.getCachedBytes(0x500000);
            }
            catch (LargeObjectException e) {
                raw = null;
            }
            if (mode == FileMode.SYMLINK) {
                type = X_GIT_SYMLINK;
            } else {
                type = this.registry.getMimeType(path, raw).toString();
                type = FileContentUtil.resolveContentType(project, path, PatchScript.FileMode.FILE, type);
            }
            BinaryResult binaryResult = FileContentUtil.asBinaryResult(raw, obj).setContentType(type).base64();
            if (tw != null) {
                tw.close();
            }
            return binaryResult;
        }
    }

    private static BinaryResult asBinaryResult(byte[] raw, final ObjectLoader obj) {
        if (raw != null) {
            return BinaryResult.create(raw);
        }
        BinaryResult result = new BinaryResult(){

            @Override
            public void writeTo(OutputStream os) throws IOException {
                obj.copyTo(os);
            }
        };
        result.setContentLength(obj.getSize());
        return result;
    }

    /*
     * Exception decompiling
     */
    public BinaryResult downloadContent(ProjectState project, ObjectId revstr, String path, @Nullable Integer parent) throws ResourceNotFoundException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private BinaryResult wrapBlob(String path, ObjectLoader obj, byte[] raw, MimeType contentType, @Nullable String suffix) {
        return FileContentUtil.asBinaryResult(raw, obj).setContentType(contentType.toString()).setAttachmentName(FileContentUtil.safeFileName(path, suffix));
    }

    private BinaryResult zipBlob(final String path, final ObjectLoader obj, RevCommit commit, final @Nullable String suffix) {
        final String commitName = commit.getName();
        final long when = (long)commit.getCommitTime() * 1000L;
        return new BinaryResult(){

            @Override
            public void writeTo(OutputStream os) throws IOException {
                try (ZipOutputStream zipOut = new ZipOutputStream(os);){
                    String decoration = FileContentUtil.randSuffix();
                    if (!Strings.isNullOrEmpty(suffix)) {
                        decoration = suffix + '-' + decoration;
                    }
                    ZipEntry e = new ZipEntry(FileContentUtil.safeFileName(path, decoration));
                    e.setComment(commitName + ":" + path);
                    e.setSize(obj.getSize());
                    e.setTime(when);
                    zipOut.putNextEntry(e);
                    obj.copyTo(zipOut);
                    zipOut.closeEntry();
                }
            }
        }.setContentType(ZIP_TYPE).setAttachmentName(FileContentUtil.safeFileName(path, suffix) + ".zip").disableGzip();
    }

    private static String safeFileName(String fileName, @Nullable String suffix) {
        int slash = fileName.lastIndexOf(47);
        if (slash >= 0) {
            fileName = fileName.substring(slash + 1);
        }
        StringBuilder r = new StringBuilder(fileName.length());
        for (int i = 0; i < fileName.length(); ++i) {
            char c = fileName.charAt(i);
            if (c == '_' || c == '-' || c == '.' || c == '@') {
                r.append(c);
                continue;
            }
            if ('0' <= c && c <= '9') {
                r.append(c);
                continue;
            }
            if ('A' <= c && c <= 'Z') {
                r.append(c);
                continue;
            }
            if ('a' <= c && c <= 'z') {
                r.append(c);
                continue;
            }
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t') {
                r.append('-');
                continue;
            }
            r.append('_');
        }
        fileName = r.toString();
        int ext = fileName.lastIndexOf(46);
        if (suffix == null) {
            return fileName;
        }
        if (ext <= 0) {
            return fileName + "_" + suffix;
        }
        return fileName.substring(0, ext) + "_" + suffix + fileName.substring(ext);
    }

    private static String randSuffix() {
        Hasher h = Hashing.murmur3_128().newHasher();
        byte[] buf = new byte[8];
        NB.encodeInt64(buf, 0, TimeUtil.nowMs());
        h.putBytes(buf);
        rng.nextBytes(buf);
        h.putBytes(buf);
        return h.hash().toString();
    }

    public static String resolveContentType(ProjectState project, String path, PatchScript.FileMode fileMode, String mimeType) {
        switch (fileMode) {
            case FILE: {
                if ("/COMMIT_MSG".equals(path)) {
                    return TEXT_X_GERRIT_COMMIT_MESSAGE;
                }
                if ("/MERGE_LIST".equals(path)) {
                    return TEXT_X_GERRIT_MERGE_LIST;
                }
                if (project != null) {
                    for (ProjectState p : project.tree()) {
                        String t = p.getConfig().getMimeTypes().getMimeType(path);
                        if (t == null) continue;
                        return t;
                    }
                }
                return mimeType;
            }
            case GITLINK: {
                return X_GIT_GITLINK;
            }
            case SYMLINK: {
                return X_GIT_SYMLINK;
            }
        }
        throw new IllegalStateException("file mode: " + (Object)((Object)fileMode));
    }

    private Repository openRepository(ProjectState project) throws RepositoryNotFoundException, IOException {
        return this.repoManager.openRepository(project.getNameKey());
    }
}

