/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.Lists;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.api.changes.RelatedChangeAndCommitInfo;
import com.google.gerrit.extensions.api.changes.RelatedChangesInfo;
import com.google.gerrit.extensions.common.CommitInfo;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CommonConverters;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.change.RelatedChangesSorter;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.revwalk.RevCommit;

@Singleton
public class GetRelated
implements RestReadView<RevisionResource> {
    private final Provider<ReviewDb> db;
    private final Provider<InternalChangeQuery> queryProvider;
    private final PatchSetUtil psUtil;
    private final RelatedChangesSorter sorter;

    @Inject
    GetRelated(Provider<ReviewDb> db, Provider<InternalChangeQuery> queryProvider, PatchSetUtil psUtil, RelatedChangesSorter sorter) {
        this.db = db;
        this.queryProvider = queryProvider;
        this.psUtil = psUtil;
        this.sorter = sorter;
    }

    public RelatedChangesInfo apply(RevisionResource rsrc) throws RepositoryNotFoundException, IOException, OrmException, NoSuchProjectException, PermissionBackendException {
        RelatedChangesInfo relatedChangesInfo = new RelatedChangesInfo();
        relatedChangesInfo.changes = this.getRelated(rsrc);
        return relatedChangesInfo;
    }

    private List<RelatedChangeAndCommitInfo> getRelated(RevisionResource rsrc) throws OrmException, IOException, PermissionBackendException {
        Set<String> groups = this.getAllGroups(rsrc.getNotes());
        if (groups.isEmpty()) {
            return Collections.emptyList();
        }
        List<ChangeData> cds = this.queryProvider.get().enforceVisibility(true).byProjectGroups(rsrc.getChange().getProject(), groups);
        if (cds.isEmpty()) {
            return Collections.emptyList();
        }
        if (cds.size() == 1 && cds.get(0).getId().equals(rsrc.getChange().getId())) {
            return Collections.emptyList();
        }
        ArrayList<RelatedChangeAndCommitInfo> result = new ArrayList<RelatedChangeAndCommitInfo>(cds.size());
        boolean isEdit = rsrc.getEdit().isPresent();
        PatchSet basePs = isEdit ? rsrc.getEdit().get().getBasePatchSet() : rsrc.getPatchSet();
        this.reloadChangeIfStale(cds, basePs);
        for (RelatedChangesSorter.PatchSetData d : this.sorter.sort(cds, basePs, rsrc.getUser())) {
            RevCommit commit;
            PatchSet ps = d.patchSet();
            if (isEdit && ps.getId().equals(basePs.getId())) {
                ps = rsrc.getPatchSet();
                commit = rsrc.getEdit().get().getEditCommit();
            } else {
                commit = d.commit();
            }
            result.add(GetRelated.newChangeAndCommit(rsrc.getProject(), d.data().change(), ps, commit));
        }
        if (result.size() == 1) {
            RelatedChangeAndCommitInfo r = (RelatedChangeAndCommitInfo)result.get(0);
            if (r.commit != null && r.commit.commit.equals(rsrc.getPatchSet().getRevision().get())) {
                return Collections.emptyList();
            }
        }
        return result;
    }

    private Set<String> getAllGroups(ChangeNotes notes) throws OrmException {
        HashSet<String> result = new HashSet<String>();
        for (PatchSet ps : this.psUtil.byChange(this.db.get(), notes)) {
            result.addAll(ps.getGroups());
        }
        return result;
    }

    private void reloadChangeIfStale(List<ChangeData> cds, PatchSet wantedPs) throws OrmException {
        for (ChangeData cd : cds) {
            if (!cd.getId().equals(wantedPs.getId().getParentKey()) || cd.patchSet(wantedPs.getId()) != null) continue;
            cd.reloadChange();
        }
    }

    static RelatedChangeAndCommitInfo newChangeAndCommit(Project.NameKey project, @Nullable Change change, @Nullable PatchSet ps, RevCommit c) {
        RelatedChangeAndCommitInfo info = new RelatedChangeAndCommitInfo();
        info.project = project.get();
        if (change != null) {
            info.changeId = change.getKey().get();
            info._changeNumber = change.getChangeId();
            info._revisionNumber = ps != null ? Integer.valueOf(ps.getPatchSetId()) : null;
            PatchSet.Id curr = change.currentPatchSetId();
            info._currentRevisionNumber = curr != null ? Integer.valueOf(curr.get()) : null;
            info.status = change.getStatus().asChangeStatus().toString();
        }
        info.commit = new CommitInfo();
        info.commit.commit = c.name();
        info.commit.parents = Lists.newArrayListWithCapacity(c.getParentCount());
        for (int i = 0; i < c.getParentCount(); ++i) {
            CommitInfo p = new CommitInfo();
            p.commit = c.getParent(i).name();
            info.commit.parents.add(p);
        }
        info.commit.author = CommonConverters.toGitPerson(c.getAuthorIdent());
        info.commit.subject = c.getShortMessage();
        return info;
    }
}

