/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.extensions.api.changes.DraftInput;
import com.google.gerrit.extensions.common.CommentInfo;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.change.CommentJson;
import com.google.gerrit.server.change.DeleteDraftComment;
import com.google.gerrit.server.change.DraftCommentResource;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.RetryHelper;
import com.google.gerrit.server.update.RetryingRestModifyView;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Optional;

@Singleton
public class PutDraftComment
extends RetryingRestModifyView<DraftCommentResource, DraftInput, Response<CommentInfo>> {
    private final Provider<ReviewDb> db;
    private final DeleteDraftComment delete;
    private final CommentsUtil commentsUtil;
    private final PatchSetUtil psUtil;
    private final Provider<CommentJson> commentJson;
    private final PatchListCache patchListCache;

    @Inject
    PutDraftComment(Provider<ReviewDb> db, DeleteDraftComment delete, CommentsUtil commentsUtil, PatchSetUtil psUtil, RetryHelper retryHelper, Provider<CommentJson> commentJson, PatchListCache patchListCache) {
        super(retryHelper);
        this.db = db;
        this.delete = delete;
        this.commentsUtil = commentsUtil;
        this.psUtil = psUtil;
        this.commentJson = commentJson;
        this.patchListCache = patchListCache;
    }

    @Override
    protected Response<CommentInfo> applyImpl(BatchUpdate.Factory updateFactory, DraftCommentResource rsrc, DraftInput in) throws RestApiException, UpdateException, OrmException {
        if (in == null || in.message == null || in.message.trim().isEmpty()) {
            return this.delete.applyImpl(updateFactory, rsrc, null);
        }
        if (in.id != null && !rsrc.getId().equals(in.id)) {
            throw new BadRequestException("id must match URL");
        }
        if (in.line != null && in.line < 0) {
            throw new BadRequestException("line must be >= 0");
        }
        if (in.line != null && in.range != null && in.line != in.range.endLine) {
            throw new BadRequestException("range endLine must be on the same line as the comment");
        }
        try (BatchUpdate bu = updateFactory.create(this.db.get(), rsrc.getChange().getProject(), rsrc.getUser(), TimeUtil.nowTs());){
            Op op = new Op(rsrc.getComment().key, in);
            bu.addOp(rsrc.getChange().getId(), op);
            bu.execute();
            Response<CommentInfo> response = Response.ok(this.commentJson.get().setFillAccounts(false).newCommentFormatter().format(op.comment));
            return response;
        }
    }

    private static Comment update(Comment e, DraftInput in, Timestamp when) {
        if (in.side != null) {
            e.side = in.side();
        }
        if (in.inReplyTo != null) {
            e.parentUuid = Url.decode(in.inReplyTo);
        }
        e.setLineNbrAndRange(in.line, in.range);
        e.message = in.message.trim();
        e.writtenOn = when;
        if (in.tag != null) {
            e.tag = in.tag;
        }
        if (in.unresolved != null) {
            e.unresolved = in.unresolved;
        }
        return e;
    }

    private class Op
    implements BatchUpdateOp {
        private final Comment.Key key;
        private final DraftInput in;
        private Comment comment;

        private Op(Comment.Key key, DraftInput in) {
            this.key = key;
            this.in = in;
        }

        @Override
        public boolean updateChange(ChangeContext ctx) throws ResourceNotFoundException, OrmException, PatchListNotAvailableException {
            Optional<Comment> maybeComment = PutDraftComment.this.commentsUtil.getDraft(ctx.getDb(), ctx.getNotes(), ctx.getIdentifiedUser(), this.key);
            if (!maybeComment.isPresent()) {
                throw new ResourceNotFoundException("comment not found: " + this.key);
            }
            Comment origComment = maybeComment.get();
            this.comment = new Comment(origComment);
            ctx.getUser().updateRealAccountId(this.comment::setRealAuthor);
            PatchSet.Id psId = new PatchSet.Id(ctx.getChange().getId(), origComment.key.patchSetId);
            ChangeUpdate update = ctx.getUpdate(psId);
            PatchSet ps = PutDraftComment.this.psUtil.get(ctx.getDb(), ctx.getNotes(), psId);
            if (ps == null) {
                throw new ResourceNotFoundException("patch set not found: " + psId);
            }
            if (this.in.path != null && !this.in.path.equals(origComment.key.filename)) {
                PutDraftComment.this.commentsUtil.deleteComments(ctx.getDb(), update, Collections.singleton(origComment));
                this.comment.key.filename = this.in.path;
            }
            CommentsUtil.setCommentRevId(this.comment, PutDraftComment.this.patchListCache, ctx.getChange(), ps);
            PutDraftComment.this.commentsUtil.putComments(ctx.getDb(), update, PatchLineComment.Status.DRAFT, Collections.singleton(PutDraftComment.update(this.comment, this.in, ctx.getWhen())));
            ctx.dontBumpLastUpdatedOn();
            return true;
        }
    }
}

