/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.common.data.LabelValue;
import com.google.gerrit.common.data.SubmitRecord;
import com.google.gerrit.extensions.api.changes.ReviewerInfo;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountLoader;
import com.google.gerrit.server.change.ReviewerResource;
import com.google.gerrit.server.permissions.LabelPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.SubmitRuleEvaluator;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;

@Singleton
public class ReviewerJson {
    private final Provider<ReviewDb> db;
    private final PermissionBackend permissionBackend;
    private final ChangeData.Factory changeDataFactory;
    private final ApprovalsUtil approvalsUtil;
    private final AccountLoader.Factory accountLoaderFactory;
    private final SubmitRuleEvaluator.Factory submitRuleEvaluatorFactory;

    @Inject
    ReviewerJson(Provider<ReviewDb> db, PermissionBackend permissionBackend, ChangeData.Factory changeDataFactory, ApprovalsUtil approvalsUtil, AccountLoader.Factory accountLoaderFactory, SubmitRuleEvaluator.Factory submitRuleEvaluatorFactory) {
        this.db = db;
        this.permissionBackend = permissionBackend;
        this.changeDataFactory = changeDataFactory;
        this.approvalsUtil = approvalsUtil;
        this.accountLoaderFactory = accountLoaderFactory;
        this.submitRuleEvaluatorFactory = submitRuleEvaluatorFactory;
    }

    public List<ReviewerInfo> format(Collection<ReviewerResource> rsrcs) throws OrmException, PermissionBackendException {
        ArrayList<ReviewerInfo> infos = Lists.newArrayListWithCapacity(rsrcs.size());
        AccountLoader loader = this.accountLoaderFactory.create(true);
        ChangeData cd = null;
        for (ReviewerResource rsrc : rsrcs) {
            if (cd == null || !cd.getId().equals(rsrc.getChangeId())) {
                cd = this.changeDataFactory.create(this.db.get(), rsrc.getChangeResource().getNotes());
            }
            ReviewerInfo info = this.format(rsrc.getChangeResource().getUser(), new ReviewerInfo(rsrc.getReviewerUser().getAccountId().get()), ((PermissionBackend.WithUser)this.permissionBackend.user(rsrc.getReviewerUser()).database(this.db)).change(cd), cd);
            loader.put(info);
            infos.add(info);
        }
        loader.fill();
        return infos;
    }

    public List<ReviewerInfo> format(ReviewerResource rsrc) throws OrmException, PermissionBackendException {
        return this.format(ImmutableList.of(rsrc));
    }

    public ReviewerInfo format(CurrentUser user, ReviewerInfo out, PermissionBackend.ForChange perm, ChangeData cd) throws OrmException, PermissionBackendException {
        PatchSet.Id psId = cd.change().currentPatchSetId();
        return this.format(user, out, perm, cd, this.approvalsUtil.byPatchSetUser(this.db.get(), cd.notes(), perm.user(), psId, new Account.Id(out._accountId), null, null));
    }

    public ReviewerInfo format(CurrentUser user, ReviewerInfo out, PermissionBackend.ForChange perm, ChangeData cd, Iterable<PatchSetApproval> approvals) throws OrmException, PermissionBackendException {
        LabelTypes labelTypes = cd.getLabelTypes();
        out.approvals = new TreeMap<String, String>(labelTypes.nameComparator());
        for (PatchSetApproval ca : approvals) {
            LabelType at = labelTypes.byLabel(ca.getLabelId());
            if (at == null) continue;
            out.approvals.put(at.getName(), LabelValue.formatValue(ca.getValue()));
        }
        PatchSet ps = cd.currentPatchSet();
        if (ps != null) {
            for (SubmitRecord rec : this.submitRuleEvaluatorFactory.create(user, cd).setFastEvalLabels(true).evaluate()) {
                if (rec.labels == null) continue;
                for (SubmitRecord.Label label : rec.labels) {
                    String name = label.label;
                    LabelType type = labelTypes.byLabel(name);
                    if (out.approvals.containsKey(name) || type == null || !perm.test(new LabelPermission(type))) continue;
                    out.approvals.put(name, LabelValue.formatValue((short)0));
                }
            }
        }
        if (out.approvals.isEmpty()) {
            out.approvals = null;
        }
        return out;
    }
}

