/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.account.AccountsCollection;
import com.google.gerrit.server.change.ListRevisionReviewers;
import com.google.gerrit.server.change.ReviewerResource;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.mail.Address;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;

@Singleton
public class RevisionReviewers
implements ChildCollection<RevisionResource, ReviewerResource> {
    private final DynamicMap<RestView<ReviewerResource>> views;
    private final Provider<ReviewDb> dbProvider;
    private final ApprovalsUtil approvalsUtil;
    private final AccountsCollection accounts;
    private final ReviewerResource.Factory resourceFactory;
    private final ListRevisionReviewers list;

    @Inject
    RevisionReviewers(Provider<ReviewDb> dbProvider, ApprovalsUtil approvalsUtil, AccountsCollection accounts, ReviewerResource.Factory resourceFactory, DynamicMap<RestView<ReviewerResource>> views, ListRevisionReviewers list) {
        this.dbProvider = dbProvider;
        this.approvalsUtil = approvalsUtil;
        this.accounts = accounts;
        this.resourceFactory = resourceFactory;
        this.views = views;
        this.list = list;
    }

    @Override
    public DynamicMap<RestView<ReviewerResource>> views() {
        return this.views;
    }

    @Override
    public RestView<RevisionResource> list() {
        return this.list;
    }

    @Override
    public ReviewerResource parse(RevisionResource rsrc, IdString id) throws OrmException, ResourceNotFoundException, AuthException, MethodNotAllowedException, IOException, ConfigInvalidException {
        Account.Id accountId;
        Address address;
        block5: {
            if (!rsrc.isCurrent()) {
                throw new MethodNotAllowedException("Cannot access on non-current patch set");
            }
            address = Address.tryParse(id.get());
            accountId = null;
            try {
                accountId = this.accounts.parse(TopLevelResource.INSTANCE, id).getUser().getAccountId();
            }
            catch (ResourceNotFoundException e) {
                if (address != null) break block5;
                throw e;
            }
        }
        ImmutableSet<Account.Id> reviewers = this.approvalsUtil.getReviewers(this.dbProvider.get(), rsrc.getNotes()).all();
        if (reviewers.contains(accountId)) {
            return this.resourceFactory.create(rsrc, accountId);
        }
        if (address != null && rsrc.getNotes().getReviewersByEmail().all().contains(address)) {
            return new ReviewerResource(rsrc, address);
        }
        throw new ResourceNotFoundException(id);
    }
}

