/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.extensions.client.GeneralPreferencesInfo;
import com.google.gerrit.reviewdb.client.CoreDownloadSchemes;
import com.google.gerrit.server.change.ArchiveFormat;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.jgit.lib.Config;

@Singleton
public class DownloadConfig {
    private final ImmutableSet<String> downloadSchemes;
    private final ImmutableSet<GeneralPreferencesInfo.DownloadCommand> downloadCommands;
    private final ImmutableSet<ArchiveFormat> archiveFormats;

    @Inject
    DownloadConfig(@GerritServerConfig Config cfg) {
        String[] allSchemes = cfg.getStringList("download", null, "scheme");
        if (allSchemes.length == 0) {
            this.downloadSchemes = ImmutableSet.of("ssh", "http", "anonymous http");
        } else {
            ArrayList<String> normalized = new ArrayList<String>(allSchemes.length);
            for (String s : allSchemes) {
                String core = DownloadConfig.toCoreScheme(s);
                if (core == null) {
                    throw new IllegalArgumentException("not a core download scheme: " + s);
                }
                normalized.add(core);
            }
            this.downloadSchemes = ImmutableSet.copyOf(normalized);
        }
        Enum[] downloadCommandValues = GeneralPreferencesInfo.DownloadCommand.values();
        List allCommands = ConfigUtil.getEnumList((Config)cfg, (String)"download", null, (String)"command", (Enum[])downloadCommandValues, null);
        this.downloadCommands = DownloadConfig.isOnlyNull(allCommands) ? ImmutableSet.copyOf(downloadCommandValues) : ImmutableSet.copyOf(allCommands);
        String v = cfg.getString("download", null, "archive");
        this.archiveFormats = v == null ? ImmutableSet.copyOf(EnumSet.allOf(ArchiveFormat.class)) : (v.isEmpty() || "off".equalsIgnoreCase(v) ? ImmutableSet.of() : ImmutableSet.copyOf(ConfigUtil.getEnumList(cfg, "download", null, "archive", ArchiveFormat.TGZ)));
    }

    private static boolean isOnlyNull(List<?> list) {
        return list.size() == 1 && list.get(0) == null;
    }

    private static String toCoreScheme(String s) {
        try {
            Field f = CoreDownloadSchemes.class.getField(s.toUpperCase());
            int m = 25;
            if ((f.getModifiers() & m) == m && f.getType() == String.class) {
                return (String)f.get(null);
            }
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return null;
        }
    }

    public ImmutableSet<String> getDownloadSchemes() {
        return this.downloadSchemes;
    }

    public ImmutableSet<GeneralPreferencesInfo.DownloadCommand> getDownloadCommands() {
        return this.downloadCommands;
    }

    public ImmutableSet<ArchiveFormat> getArchiveFormats() {
        return this.archiveFormats;
    }
}

