/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.extensions.annotations.RequiresAnyCapability;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.config.CacheResource;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@RequiresAnyCapability(value={"flushCaches", "maintainServer"})
@Singleton
public class FlushCache
implements RestModifyView<CacheResource, Input> {
    public static final String WEB_SESSIONS = "web_sessions";
    private final PermissionBackend permissionBackend;
    private final Provider<CurrentUser> self;

    @Inject
    public FlushCache(PermissionBackend permissionBackend, Provider<CurrentUser> self) {
        this.permissionBackend = permissionBackend;
        this.self = self;
    }

    public Response<String> apply(CacheResource rsrc, Input input) throws AuthException, PermissionBackendException {
        if (WEB_SESSIONS.equals(rsrc.getName())) {
            this.permissionBackend.user(this.self).check(GlobalPermission.MAINTAIN_SERVER);
        }
        rsrc.getCache().invalidateAll();
        return Response.ok("");
    }

    public static class Input {
    }
}

