/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.edit.tree;

import com.google.gerrit.server.edit.tree.AddPath;
import com.google.gerrit.server.edit.tree.TreeModification;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;

public class RenameFileModification
implements TreeModification {
    private final String currentFilePath;
    private final String newFilePath;

    public RenameFileModification(String currentFilePath, String newFilePath) {
        this.currentFilePath = currentFilePath;
        this.newFilePath = newFilePath;
    }

    @Override
    public List<DirCacheEditor.PathEdit> getPathEdits(Repository repository, RevCommit baseCommit) throws IOException {
        try (RevWalk revWalk = new RevWalk(repository);){
            TreeWalk treeWalk;
            block15: {
                revWalk.parseHeaders(baseCommit);
                treeWalk = TreeWalk.forPath(revWalk.getObjectReader(), this.currentFilePath, baseCommit.getTree());
                try {
                    if (treeWalk != null) break block15;
                    List<DirCacheEditor.PathEdit> list = Collections.emptyList();
                    if (treeWalk != null) {
                        treeWalk.close();
                    }
                    return list;
                }
                catch (Throwable throwable) {
                    if (treeWalk != null) {
                        try {
                            treeWalk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            DirCacheEditor.DeletePath deletePathEdit = new DirCacheEditor.DeletePath(this.currentFilePath);
            AddPath addPathEdit = new AddPath(this.newFilePath, treeWalk.getFileMode(0), treeWalk.getObjectId(0));
            List<DirCacheEditor.PathEdit> list = Arrays.asList(deletePathEdit, addPathEdit);
            if (treeWalk != null) {
                treeWalk.close();
            }
            return list;
        }
    }

    @Override
    public String getFilePath() {
        return this.newFilePath;
    }
}

